/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.voms.xmlobject.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import org.glite.sts.voms.xmlobject.FQAN;
import org.glite.sts.voms.xmlobject.VomsAttributeCertificates;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.AbstractXMLObjectUnmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class VomsAttributeCertificatesUnmarshaller
extends AbstractXMLObjectUnmarshaller {
    private final Logger log = LoggerFactory.getLogger(VomsAttributeCertificatesUnmarshaller.class);

    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
        this.log.debug("Processing attributes for VomsAttributeCertificates");
        VomsAttributeCertificates vomsACs = (VomsAttributeCertificates)xmlObject;
        if (attribute.getLocalName().equals("ordering")) {
            this.log.debug("Ordering {} found, setting it for the value.", (Object)attribute.getValue());
            vomsACs.setOrdering(attribute.getValue());
        } else if (attribute.getLocalName().equals("targets")) {
            this.log.debug("Targets {} found, setting it for the value.", (Object)attribute.getValue());
            vomsACs.setTargets(attribute.getValue());
        } else if (attribute.getLocalName().equals("verificationType")) {
            this.log.debug("Verification type {} found, setting it for the value.", (Object)attribute.getValue());
            vomsACs.setVerificationType(attribute.getValue());
        } else {
            QName attribQName = QNameSupport.getNodeQName((Node)attribute);
            if (attribute.isId()) {
                vomsACs.getUnknownAttributes().registerID(attribQName);
            }
            vomsACs.getUnknownAttributes().put(attribQName, attribute.getValue());
        }
    }

    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
        this.log.debug("Processing child element for GridProxyRequest");
        VomsAttributeCertificates vomsACs = (VomsAttributeCertificates)parentXMLObject;
        if (childXMLObject instanceof FQAN) {
            this.log.debug("Setting a FQAN");
            vomsACs.getFQANs().add((FQAN)childXMLObject);
        } else {
            super.processChildElement(parentXMLObject, childXMLObject);
        }
    }
}

