/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.ta.voms;

import com.google.common.base.Function;
import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationErrorListener;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.proxy.ProxyCertificateOptions;
import eu.emi.security.authn.x509.proxy.ProxyGenerator;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateParsingException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.glite.sts.ta.TokenGenerationContext;
import org.glite.sts.ta.TokenGenerationException;
import org.glite.sts.ta.TokenGenerator;
import org.glite.sts.ta.voms.VomsEventListener;
import org.glite.sts.ta.voms.VomsTokenGenerationContext;
import org.italiangrid.voms.request.VOMSACRequest;
import org.italiangrid.voms.request.VOMSACService;
import org.italiangrid.voms.request.VOMSRequestListener;
import org.italiangrid.voms.request.impl.DefaultVOMSACRequest;
import org.italiangrid.voms.request.impl.DefaultVOMSACService;
import org.italiangrid.voms.util.CertificateValidatorBuilder;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VomsTokenGenerator
implements TokenGenerator {
    private static Logger log = LoggerFactory.getLogger(VomsTokenGenerator.class);
    private Function<TokenGenerationContext, VomsTokenGenerationContext> vomsTokenGenerationContextLookupStrategy;
    private VOMSACService vomsService;

    public VomsTokenGenerator(String vomsesPath, String vomsDir, long updateInterval, NamespaceCheckingMode namespaceCheckingMode, CrlCheckingMode crlCheckingMode, OCSPCheckingMode ocspCheckingMode) {
        log.info("Constructing a new VomsTokenGenerator with vomsesPath={} and vomsDir={}", (Object)vomsesPath, (Object)vomsDir);
        this.vomsTokenGenerationContextLookupStrategy = new ChildContextLookup(VomsTokenGenerationContext.class, false);
        VomsEventListener vomsEventListener = new VomsEventListener();
        X509CertChainValidatorExt validator = CertificateValidatorBuilder.buildCertificateValidator((String)vomsDir, (ValidationErrorListener)vomsEventListener, (StoreUpdateListener)vomsEventListener, (long)updateInterval, (NamespaceCheckingMode)namespaceCheckingMode, (CrlCheckingMode)crlCheckingMode, (OCSPCheckingMode)ocspCheckingMode);
        DefaultVOMSACService.Builder builder = new DefaultVOMSACService.Builder(validator);
        Vector<String> vomses = new Vector<String>();
        vomses.add(vomsesPath);
        builder.vomsesLocations(vomses);
        builder.requestListener((VOMSRequestListener)vomsEventListener);
        this.vomsService = builder.build();
    }

    @Override
    public void issueToken(TokenGenerationContext ctx) throws TokenGenerationException {
        VomsTokenGenerationContext vomsContext = (VomsTokenGenerationContext)((Object)this.vomsTokenGenerationContextLookupStrategy.apply((Object)ctx));
        Map<String, List<String>> fqans = vomsContext.getFqans();
        if (fqans.size() != 1) {
            log.debug("Invalid size of the VO names in the request: {}", (Object)fqans.size());
            throw new TokenGenerationException("STS only supports one VO in the request!");
        }
        String voName = fqans.entrySet().iterator().next().getKey();
        DefaultVOMSACRequest request = new DefaultVOMSACRequest.Builder(voName).lifetime(vomsContext.getLifetime()).fqans(fqans.get(voName)).build();
        AttributeCertificate attributeCertificate = this.vomsService.getVOMSAttributeCertificate(vomsContext.getIssuerCredentials(), (VOMSACRequest)request);
        log.debug("Obtained attribute certificate {}", (Object)attributeCertificate);
        if (attributeCertificate == null) {
            throw new TokenGenerationException("Could not obtain an attribute certificate from the VOMS service");
        }
        ProxyCertificateOptions proxyOptions = new ProxyCertificateOptions(vomsContext.getIssuerCredentials().getCertificateChain());
        proxyOptions.setPublicKey(vomsContext.getProxyKeys().getPublicKey());
        proxyOptions.setLifetime(vomsContext.getLifetime());
        proxyOptions.setAttributeCertificates(new AttributeCertificate[]{attributeCertificate});
        try {
            vomsContext.setProxyCredentials(ProxyGenerator.generate((ProxyCertificateOptions)proxyOptions, (PrivateKey)vomsContext.getIssuerCredentials().getKey()));
        }
        catch (InvalidKeyException e) {
            log.debug("Error during the VOMS proxy initialization", (Throwable)e);
            throw new TokenGenerationException(e);
        }
        catch (CertificateParsingException e) {
            log.debug("Error during the VOMS proxy initialization", (Throwable)e);
            throw new TokenGenerationException(e);
        }
        catch (SignatureException e) {
            log.debug("Error during the VOMS proxy initialization", (Throwable)e);
            throw new TokenGenerationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            log.debug("Error during the VOMS proxy initialization", (Throwable)e);
            throw new TokenGenerationException(e);
        }
    }
}

