/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.ta.voms;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationErrorListener;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.List;
import org.italiangrid.voms.ac.ACLookupListener;
import org.italiangrid.voms.ac.VOMSValidationResult;
import org.italiangrid.voms.ac.ValidationResultListener;
import org.italiangrid.voms.credential.LoadCredentialsEventListener;
import org.italiangrid.voms.request.VOMSACRequest;
import org.italiangrid.voms.request.VOMSErrorMessage;
import org.italiangrid.voms.request.VOMSProtocolListener;
import org.italiangrid.voms.request.VOMSRequestListener;
import org.italiangrid.voms.request.VOMSResponse;
import org.italiangrid.voms.request.VOMSServerInfo;
import org.italiangrid.voms.request.VOMSServerInfoStoreListener;
import org.italiangrid.voms.request.VOMSWarningMessage;
import org.italiangrid.voms.store.LSCInfo;
import org.italiangrid.voms.store.VOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStoreStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VomsEventListener
implements ACLookupListener,
ValidationResultListener,
VOMSServerInfoStoreListener,
LoadCredentialsEventListener,
VOMSTrustStoreStatusListener,
Thread.UncaughtExceptionHandler,
VOMSRequestListener,
VOMSProtocolListener,
ValidationErrorListener,
StoreUpdateListener {
    private static Logger log = LoggerFactory.getLogger(VomsEventListener.class);

    public void notifyVOMSRequestStart(VOMSACRequest request, VOMSServerInfo si) {
        log.debug("VOMS request start: {}", (Object)si);
    }

    public void notifyVOMSRequestSuccess(VOMSACRequest request, VOMSServerInfo endpoint) {
        log.debug("VOMS request was successful: {}", (Object)endpoint);
    }

    public void notifyVOMSRequestFailure(VOMSACRequest request, VOMSServerInfo endpoint, Throwable error) {
        log.error("VOMS request failed: {}", (Object)endpoint, (Object)error);
    }

    public void notifyErrorsInVOMSReponse(VOMSACRequest request, VOMSServerInfo si, VOMSErrorMessage[] errors) {
        log.error("The following {} errors were found: {}", (Object)errors.length, (Object)si);
        for (int i = 0; i < errors.length; ++i) {
            log.error("Error {}: {}", (Object)i, (Object)errors[i].toString());
        }
    }

    public void notifyWarningsInVOMSResponse(VOMSACRequest request, VOMSServerInfo si, VOMSWarningMessage[] warnings) {
        log.warn("The following {} warnings were found: {}", (Object)warnings.length, (Object)si);
        for (int i = 0; i < warnings.length; ++i) {
            log.warn("Error {}: {}", (Object)i, (Object)warnings[i].toString());
        }
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        log.error("Uncaught exception found: {}", e);
    }

    public void notifyTrustStoreUpdate(VOMSTrustStore store) {
        log.info("The VOMS trust store has been updated.");
    }

    public void notifyCertficateLookupEvent(String dir) {
        log.debug("Looking up a certificate in directory {}", (Object)dir);
    }

    public void notifyLSCLookupEvent(String dir) {
        log.debug("LSC lookup event occured in directory {}", (Object)dir);
    }

    public void notifyCertificateLoadEvent(X509Certificate cert, File f) {
        log.info("Loaded a certificate {}", (Object)cert.toString());
    }

    public void notifyLSCLoadEvent(LSCInfo lsc, File f) {
        log.info("LSC loaded for host {}", (Object)lsc.getHostname());
    }

    public void notifyCredentialLookup(String ... locations) {
        log.debug("Looking up for credentials {}", (Object[])locations);
    }

    public void notifyLoadCredentialSuccess(String ... locations) {
        log.info("Successfully loaded credentials from {}", (Object[])locations);
    }

    public void notifyLoadCredentialFailure(Throwable error, String ... locations) {
        log.error("Error while loading credentials from {}", (Object)locations, (Object)error);
    }

    public void notifyNoValidVOMSESError(List<String> searchedPaths) {
        log.error("Error while loading vomses files from the following paths");
        for (int i = 0; i < searchedPaths.size(); ++i) {
            log.error("Path {}: {}", (Object)i, (Object)searchedPaths.get(i));
        }
    }

    public void notifyVOMSESlookup(String vomsesPath) {
        log.debug("Looking up a vomses file from {}", (Object)vomsesPath);
    }

    public void notifyVOMSESInformationLoaded(String vomsesPath, VOMSServerInfo info) {
        log.info("The vomses file {} loaded for {}", (Object)vomsesPath, (Object)info);
    }

    public void notifyValidationResult(VOMSValidationResult result) {
        log.debug("VOMS validation result {}", (Object)result);
    }

    public void notifyACLookupEvent(X509Certificate[] chain, int chainLevel) {
        log.debug("Looking up an AC for {}", (Object)chain[chainLevel].getSubjectDN());
    }

    public void notifyACParseEvent(X509Certificate[] chain, int chainLevel) {
        log.debug("Parsing an AC for {}", (Object)chain[chainLevel].getSubjectDN());
    }

    public void notifyHTTPRequest(String url) {
        log.debug("Sending an HTTP request to {}", (Object)url);
    }

    public void notifyLegacyRequest(String xmlLegacyRequest) {
        log.debug("Sending a legacy request to {}", (Object)xmlLegacyRequest);
    }

    public void notifyReceivedResponse(VOMSResponse r) {
        log.debug("Obtained a VOMS response");
    }

    public void loadingNotification(String location, String type, StoreUpdateListener.Severity level, Exception cause) {
        log.debug("Loading a file from {}", (Object)location);
    }

    public boolean onValidationError(ValidationError error) {
        log.error("Validation error {}, code {}, message {}", new Object[]{error.getErrorCategory(), error.getErrorCode(), error.getMessage()});
        return false;
    }
}

