/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.standalone;

import eu.emi.security.authn.x509.CrlCheckingMode;
import eu.emi.security.authn.x509.NamespaceCheckingMode;
import eu.emi.security.authn.x509.OCSPCheckingMode;
import eu.emi.security.authn.x509.OCSPParametes;
import eu.emi.security.authn.x509.ProxySupport;
import eu.emi.security.authn.x509.RevocationParameters;
import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.ssl.CredentialX509KeyManager;
import eu.emi.security.authn.x509.helpers.ssl.SSLTrustManager;
import eu.emi.security.authn.x509.impl.OpensslCertChainValidator;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.impl.ValidatorParams;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.util.AbstractQueue;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.glite.sts.STSException;
import org.glite.sts.standalone.JettyShutdownCommand;
import org.glite.sts.standalone.JettySslSelectChannelConnector;
import org.glite.sts.standalone.ShutdownAndStatusService;
import org.glite.sts.standalone.StandaloneConfiguration;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.security.SslSelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneService {
    private static final Logger log = LoggerFactory.getLogger(StandaloneService.class);
    private static final String CONF_DIR_OPTION_NAME = "conf-dir";
    protected String configurationDir;
    protected Server jettyServer;
    private WebAppContext webappContext;

    public StandaloneService(String[] args) {
        try {
            this.parseOptions(args);
            Security.addProvider((Provider)new BouncyCastleProvider());
            StandaloneConfiguration.initialize(this.configurationDir);
            this.configureServer();
            this.jettyServer.start();
            if (this.webappContext.getUnavailableException() != null) {
                throw this.webappContext.getUnavailableException();
            }
            System.out.println("The STS server has been successfully started.");
            this.jettyServer.join();
        }
        catch (Throwable e) {
            log.error("The service encountered an error that could not be dealt with, shutting down!");
            log.error(e.getMessage());
            System.err.println("The service encountered an error that could not be dealt with, shutting down!");
            System.err.println("Error: " + e.getMessage());
            e.printStackTrace(System.err);
            if (log.isDebugEnabled()) {
                log.error(e.getMessage(), e);
            }
            try {
                this.jettyServer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.exit(1);
        }
    }

    private Connector configureConnector(String host, int port) throws STSException {
        Object connector;
        String scheme = this.getStringFromStandaloneConfiguration("scheme", "https");
        if (scheme.equalsIgnoreCase("https")) {
            PEMCredential credential;
            log.info("The configured scheme is HTTPS, certificate must be used.");
            String privateKey = this.getStringFromStandaloneConfiguration("privateKey", "/etc/grid-security/hostkey.pem");
            String privateKeyPwd = this.getStringFromStandaloneConfiguration("privateKeyPassword", null);
            String certificate = this.getStringFromStandaloneConfiguration("certificate", "/etc/grid-security/hostcert.pem");
            try {
                if (privateKeyPwd == null) {
                    log.debug("Initializing the PEM credential without a password");
                    credential = new PEMCredential(privateKey, certificate, null);
                } else {
                    log.debug("Initializing the PEM credential with a password");
                    credential = new PEMCredential(privateKey, certificate, privateKeyPwd.toCharArray());
                }
            }
            catch (KeyStoreException e) {
                throw new STSException("Could not initialize the private key!", e);
            }
            catch (CertificateException e) {
                throw new STSException("Could not initialize the certificate!", e);
            }
            catch (IOException e) {
                throw new STSException("Could not read the private key and/or certificate from the file", e);
            }
            String trustStoreDir = this.getStringFromStandaloneConfiguration("trustStoreDir", String.valueOf("/etc/grid-security/certificates"));
            try {
                OCSPParametes ocspParams = new OCSPParametes(OCSPCheckingMode.valueOf((String)this.getStringFromStandaloneConfiguration("ocspCheckingMode", null)));
                RevocationParameters revocationParams = new RevocationParameters(CrlCheckingMode.valueOf((String)this.getStringFromStandaloneConfiguration("crlCheckingMode", null)), ocspParams);
                ValidatorParams validatorParams = new ValidatorParams(revocationParams, ProxySupport.valueOf((String)this.getStringFromStandaloneConfiguration("proxySupport", null)));
                OpensslCertChainValidator validator = new OpensslCertChainValidator(trustStoreDir, NamespaceCheckingMode.valueOf((String)this.getStringFromStandaloneConfiguration("namespaceCheckingMode", null)), this.getLongFromStandaloneConfiguration("crlUpdateInterval", 600000L), validatorParams);
                connector = new JettySslSelectChannelConnector((X509KeyManager)new CredentialX509KeyManager((X509Credential)credential), (X509TrustManager)new SSLTrustManager((X509CertChainValidator)validator));
                ((SslSelectChannelConnector)connector).setWantClientAuth(this.getBooleanFromStandaloneConfiguration("wantClientAuth", String.valueOf(false)));
                ((SslSelectChannelConnector)connector).setNeedClientAuth(this.getBooleanFromStandaloneConfiguration("requireClientAuth", String.valueOf(false)));
            }
            catch (Exception e) {
                log.error("Error initializing connector: " + e.getMessage());
                if (log.isDebugEnabled()) {
                    log.error("Error initializing connector: " + e.getMessage(), (Throwable)e);
                }
                throw new STSException(e);
            }
        }
        log.info("The configured scheme is HTTP, no certificate used.");
        connector = new SelectChannelConnector();
        log.info("STS will listen on {}://{}:{}", new Object[]{scheme, host, port});
        connector.setPort(port);
        connector.setHost(host);
        return connector;
    }

    private void configureServer() throws STSException {
        log.info("Configuring jetty server...");
        this.jettyServer = new Server();
        int maxRequestQueueSize = this.getIntFromStandaloneConfiguration("maxRequestQueueSize", -1);
        log.debug("maxRequestQueueSize = {}", (Object)maxRequestQueueSize);
        int maxConnections = this.getIntFromStandaloneConfiguration("maxConnections", 64);
        if (maxConnections <= 0) {
            log.error("Please specify a positive value for the 'maxConnections' configuration parameter!");
            log.error("Will use the hardcoded default '{}' instead...", (Object)64);
            maxConnections = 64;
        }
        log.info("maxConnections = {}", (Object)maxConnections);
        this.jettyServer.setSendServerVersion(false);
        this.jettyServer.setSendDateHeader(false);
        AbstractQueue requestQueue = maxRequestQueueSize < 1 ? new LinkedBlockingQueue() : new ArrayBlockingQueue(maxRequestQueueSize);
        org.mortbay.thread.concurrent.ThreadPool threadPool = new org.mortbay.thread.concurrent.ThreadPool(5, maxConnections, 60L, TimeUnit.SECONDS, requestQueue);
        this.jettyServer.setThreadPool((ThreadPool)threadPool);
        int port = this.getIntFromStandaloneConfiguration("port", 443);
        String host = this.getStringFromStandaloneConfiguration("hostname", "localhost");
        this.jettyServer.setConnectors(new Connector[]{this.configureConnector(host, port)});
        JettyShutdownCommand shutdownCommand = new JettyShutdownCommand(this.jettyServer);
        ShutdownAndStatusService.startShutdownAndStatusService(this.getIntFromStandaloneConfiguration("shutdownPort", 8005), Collections.singletonList(shutdownCommand));
        this.webappContext = new WebAppContext();
        this.webappContext.setContextPath("/" + this.getStringFromStandaloneConfiguration("webappContext", "sts"));
        this.webappContext.setWar(this.getStringFromStandaloneConfiguration("warfile", "sts.war"));
        this.webappContext.setParentLoaderPriority(true);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{this.webappContext, new DefaultHandler()});
        this.jettyServer.setHandler((Handler)handlers);
    }

    private int getIntFromStandaloneConfiguration(String key, int defaultValue) {
        StandaloneConfiguration conf = null;
        try {
            conf = StandaloneConfiguration.instance();
        }
        catch (STSException e) {
            log.error("Configuration is not initialized!", (Throwable)e);
        }
        log.debug("Returning {}", (Object)conf.getInt(key, defaultValue));
        return conf.getInt(key, defaultValue);
    }

    private long getLongFromStandaloneConfiguration(String key, long defaultValue) {
        StandaloneConfiguration conf = null;
        try {
            conf = StandaloneConfiguration.instance();
        }
        catch (STSException e) {
            log.error("Configuration is not initialized!", (Throwable)e);
        }
        log.debug("Returning {}", (Object)conf.getLong(key, defaultValue));
        return conf.getLong(key, defaultValue);
    }

    private String getStringFromStandaloneConfiguration(String key, String defaultValue) {
        StandaloneConfiguration conf = null;
        try {
            conf = StandaloneConfiguration.instance();
        }
        catch (STSException e) {
            log.error("Configuration is not initialized!", (Throwable)e);
        }
        log.debug("Returning {}", (Object)conf.getString(key, defaultValue));
        return conf.getString(key, defaultValue);
    }

    private boolean getBooleanFromStandaloneConfiguration(String key, String defaultValue) {
        StandaloneConfiguration conf = null;
        try {
            conf = StandaloneConfiguration.instance();
        }
        catch (STSException e) {
            log.error("Configuration is not initialized!", (Throwable)e);
        }
        log.debug("Returning {}", (Object)conf.getString(key, defaultValue).equalsIgnoreCase("true"));
        return conf.getString(key, defaultValue).equalsIgnoreCase("true");
    }

    protected void parseOptions(String[] args) {
        if (args.length == 0) {
            this.usage();
        }
        if (args.length > 0) {
            int currentArg = 0;
            while (currentArg < args.length) {
                if (!args[currentArg].startsWith("--")) {
                    this.usage();
                    continue;
                }
                if (args[currentArg].equalsIgnoreCase("--conf-dir")) {
                    this.configurationDir = args[currentArg + 1];
                    log.info("Starting STS server with configuration dir: {}", (Object)this.configurationDir);
                    currentArg += 2;
                    continue;
                }
                this.usage();
            }
        }
    }

    private void usage() {
        String usage = "StandaloneService [--conf-dir <confDir>]";
        System.out.println(usage);
        System.exit(1);
    }

    public static void main(String[] args) {
        new StandaloneService(args);
    }

    public final class StandaloneServiceDefaults {
        public static final String SCHEME = "https";
        public static final String HOSTNAME = "localhost";
        public static final int PORT = 443;
        public static final int SHUTDOWN_PORT = 8005;
        public static final int MAX_REQUEST_QUEUE_SIZE = -1;
        public static final int MAX_CONNECTIONS = 64;
        public static final String CERTIFICATE_PATH = "/etc/grid-security/hostcert.pem";
        public static final String PRIVATE_KEY_PATH = "/etc/grid-security/hostkey.pem";
        public static final long CRL_UPDATE_INTERVAL = 600000L;
        public static final String TRUST_STORE_DIR = "/etc/grid-security/certificates";
        public static final boolean REQUIRE_CLIENT_AUTH = false;
        public static final boolean WANT_CLIENT_AUTH = false;
    }
}

