/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.standalone;

import java.io.File;
import org.glite.sts.STSException;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class StandaloneConfiguration {
    private static StandaloneConfiguration instance;
    private Profile.Section iniSection;

    private StandaloneConfiguration(String configurationDir) throws STSException {
        String iniFile = !configurationDir.substring(configurationDir.length() - 1).equals("/") ? configurationDir + "/sts-server.ini" : configurationDir + "sts-server.ini";
        try {
            Ini ini = new Ini(new File(iniFile));
            this.iniSection = (Profile.Section)ini.get((Object)"StandaloneServer");
        }
        catch (Exception e) {
            throw new STSException("Could not initialize the configuration", e);
        }
    }

    public static StandaloneConfiguration initialize(String configurationDir) throws STSException {
        if (instance == null) {
            instance = new StandaloneConfiguration(configurationDir);
        }
        return instance;
    }

    public static StandaloneConfiguration instance() throws STSException {
        if (instance == null) {
            throw new STSException("Please initialize configuration before calling the instance method!");
        }
        return instance;
    }

    public String getString(String key) {
        return (String)this.iniSection.get((Object)key);
    }

    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        if (value == null || value.equals("")) {
            return defaultValue;
        }
        return value;
    }

    public int getInt(String key, int defaultValue) {
        return new Integer(this.getString(key, "" + defaultValue));
    }

    public long getLong(String key, long defaultValue) {
        return new Long(this.getString(key, "" + defaultValue));
    }
}

