/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.saml.idstore.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import org.glite.sts.saml.idstore.AuthnRequestId;
import org.glite.sts.saml.idstore.StorageService;
import org.glite.sts.saml.idstore.impl.AuthnRequestIdImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryStorageService
implements StorageService {
    private final Logger log = LoggerFactory.getLogger(InMemoryStorageService.class);
    private Hashtable<String, AuthnRequestId> authnRequestIds;

    public InMemoryStorageService(Timer timer, long frequency) {
        this.log.info("Building a new Storage Service with sweeping frequency of {}", (Object)frequency);
        this.authnRequestIds = new Hashtable();
        timer.schedule((TimerTask)new MemoryCleaningTask(), 0L, frequency);
    }

    @Override
    public void put(String id, long lifetime) {
        AuthnRequestIdImpl authnRequestId = new AuthnRequestIdImpl(id, lifetime);
        this.log.debug("Putting an id {} to the storage", (Object)authnRequestId.getId());
        this.authnRequestIds.put(authnRequestId.getId(), authnRequestId);
    }

    @Override
    public void remove(String id) {
        this.log.debug("Removing an id {} from the storage", (Object)id);
        this.authnRequestIds.remove(id);
    }

    @Override
    public boolean exists(String id) {
        if (id == null) {
            return false;
        }
        if (this.authnRequestIds.containsKey(id)) {
            return true;
        }
        this.log.debug("Id {} not found", (Object)id);
        return false;
    }

    class MemoryCleaningTask
    extends TimerTask {
        MemoryCleaningTask() {
        }

        @Override
        public void run() {
            InMemoryStorageService.this.log.debug("Running the cleaning task for the expired identifiers");
            Enumeration enumeration = InMemoryStorageService.this.authnRequestIds.elements();
            while (enumeration.hasMoreElements()) {
                AuthnRequestId authnRequestId = (AuthnRequestId)enumeration.nextElement();
                if (authnRequestId.isValid()) continue;
                InMemoryStorageService.this.log.debug("Cleaning the id {} from the storage", (Object)authnRequestId.getId());
                InMemoryStorageService.this.authnRequestIds.remove(authnRequestId.getId());
            }
        }
    }
}

