/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile.xmlsec;

import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.KeyInfoBuilder;
import org.opensaml.xmlsec.signature.impl.SignatureBuilder;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSecActionSupport {
    @Nonnull
    public static Signature buildSignatureObject(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Credential credential) {
        SignatureBuilder builder = (SignatureBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME);
        SignatureImpl signature = builder.buildObject();
        signature.setSigningCredential(credential);
        signature.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.setKeyInfo(XmlSecActionSupport.buildKeyInfoObject(action));
        XmlSecActionSupport.getLogger().debug("Action {}: Signature object built.", (Object)action.getId());
        return signature;
    }

    @Nonnull
    public static KeyInfo buildKeyInfoObject(@Nonnull AbstractProfileAction<?, ?> action) {
        KeyInfoBuilder builder = (KeyInfoBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(KeyInfo.DEFAULT_ELEMENT_NAME);
        KeyInfo keyInfo = builder.buildObject();
        XmlSecActionSupport.getLogger().debug("Action {}: KeyInfo object built.", (Object)action.getId());
        return keyInfo;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(XmlSecActionSupport.class);
    }
}

