/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile.wstrust;

import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import org.glite.sts.profile.soap.SoapActionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.wssecurity.BinarySecurityToken;
import org.opensaml.soap.wssecurity.Reference;
import org.opensaml.soap.wssecurity.Security;
import org.opensaml.soap.wssecurity.SecurityTokenReference;
import org.opensaml.soap.wssecurity.WSSecurityObjectBuilder;
import org.opensaml.soap.wstrust.BinarySecret;
import org.opensaml.soap.wstrust.RequestSecurityTokenResponse;
import org.opensaml.soap.wstrust.RequestSecurityTokenResponseCollection;
import org.opensaml.soap.wstrust.RequestedProofToken;
import org.opensaml.soap.wstrust.RequestedSecurityToken;
import org.opensaml.soap.wstrust.TokenType;
import org.opensaml.soap.wstrust.WSTrustObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WsTrustActionSupport {
    @Nonnull
    public static BinarySecurityToken addBinarySecurityTokenToRequestedToken(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull RequestedSecurityToken requestedToken) {
        WSSecurityObjectBuilder builder = (WSSecurityObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(BinarySecurityToken.ELEMENT_NAME);
        BinarySecurityToken token = (BinarySecurityToken)builder.buildObject();
        requestedToken.setUnknownXMLObject((XMLObject)token);
        WsTrustActionSupport.getLogger().debug("Action {}: Added BinarySecurityToken as the RequestedToken's content", (Object)action.getId());
        return token;
    }

    @Nonnull
    public static BinarySecurityToken addBinarySecurityTokenToSecurityHeader(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Security security) {
        WSSecurityObjectBuilder builder = (WSSecurityObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(BinarySecurityToken.ELEMENT_NAME);
        BinarySecurityToken token = (BinarySecurityToken)builder.buildObject();
        security.getUnknownXMLObjects().add(token);
        WsTrustActionSupport.getLogger().debug("Action {}: Added BinarySecurityToken as the Security's content", (Object)action.getId());
        return token;
    }

    @Nonnull
    public static SecurityTokenReference addSecurityTokenReferenceToRequestedToken(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull RequestedSecurityToken requestedToken) {
        WSSecurityObjectBuilder builder = (WSSecurityObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(SecurityTokenReference.ELEMENT_NAME);
        SecurityTokenReference reference = (SecurityTokenReference)builder.buildObject();
        requestedToken.setUnknownXMLObject((XMLObject)reference);
        WsTrustActionSupport.getLogger().debug("Action {}: Added SecurityTokenReference as the RequestedToken's content", (Object)action.getId());
        return reference;
    }

    @Nonnull
    public static Reference addReferenceToSecurityTokenReference(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull SecurityTokenReference tokenReference) {
        WSSecurityObjectBuilder builder = (WSSecurityObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Reference.ELEMENT_NAME);
        Reference reference = (Reference)builder.buildObject();
        tokenReference.getUnknownXMLObjects().add(reference);
        WsTrustActionSupport.getLogger().debug("Action {}: Added Reference as the SecurityTokenReference's content", (Object)action.getId());
        return reference;
    }

    @Nonnull
    public static BinarySecret addBinarySecretToProofToken(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull RequestedProofToken proofToken) {
        WSTrustObjectBuilder builder = (WSTrustObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(BinarySecret.ELEMENT_NAME);
        BinarySecret secret = (BinarySecret)builder.buildObject();
        proofToken.setUnknownXMLObject((XMLObject)secret);
        WsTrustActionSupport.getLogger().debug("Action {}: Added BinarySecret to RequestedProofToken", (Object)action.getId());
        return secret;
    }

    @Nonnull
    public static TokenType addTokenTypeToRSTR(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull RequestSecurityTokenResponse rstr) {
        WSTrustObjectBuilder builder = (WSTrustObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(TokenType.ELEMENT_NAME);
        TokenType tokenType = (TokenType)builder.buildObject();
        rstr.getUnknownXMLObjects().add(tokenType);
        WsTrustActionSupport.getLogger().debug("Action {}: Added TokenType to RSTR", (Object)action.getId());
        return tokenType;
    }

    @Nonnull
    public static RequestedSecurityToken addRequestedTokenToRSTR(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull RequestSecurityTokenResponse rstr) {
        WSTrustObjectBuilder builder = (WSTrustObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(RequestedSecurityToken.ELEMENT_NAME);
        RequestedSecurityToken requestedToken = (RequestedSecurityToken)builder.buildObject();
        rstr.getUnknownXMLObjects().add(requestedToken);
        WsTrustActionSupport.getLogger().debug("Action {}: Added RequestedSecurityToken to RSTR", (Object)action.getId());
        return requestedToken;
    }

    @Nonnull
    public static RequestedProofToken addRequestedProofTokenToRSTR(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull RequestSecurityTokenResponse rstr) {
        WSTrustObjectBuilder builder = (WSTrustObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(RequestedProofToken.ELEMENT_NAME);
        RequestedProofToken requestedProof = (RequestedProofToken)builder.buildObject();
        rstr.getUnknownXMLObjects().add(requestedProof);
        WsTrustActionSupport.getLogger().debug("Action {}: Added RequestedProofToken to RSTR", (Object)action.getId());
        return requestedProof;
    }

    @Nonnull
    public static RequestSecurityTokenResponse addRSTRtoRSTRC(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull RequestSecurityTokenResponseCollection rstrc) {
        WSTrustObjectBuilder builder = (WSTrustObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(RequestSecurityTokenResponse.ELEMENT_NAME);
        RequestSecurityTokenResponse rstr = (RequestSecurityTokenResponse)builder.buildObject();
        rstrc.getRequestSecurityTokenResponses().add(rstr);
        WsTrustActionSupport.getLogger().debug("Action {}: Added RSTR object to RSTRC", (Object)action.getId());
        return rstr;
    }

    @Nonnull
    public static RequestSecurityTokenResponseCollection addRSTRCtoEnvelopeBody(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Envelope envelope) {
        WSTrustObjectBuilder builder = (WSTrustObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(RequestSecurityTokenResponseCollection.ELEMENT_NAME);
        RequestSecurityTokenResponseCollection rstrc = (RequestSecurityTokenResponseCollection)builder.buildObject();
        SoapActionSupport.addBodytoEnvelope(action, envelope).getUnknownXMLObjects().add(rstrc);
        WsTrustActionSupport.getLogger().debug("Action {}: Added RSTRC object to the Envelope's Body", (Object)action.getId());
        return rstrc;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(WsTrustActionSupport.class);
    }
}

