/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile.wssecurity;

import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wssecurity.Created;
import org.opensaml.soap.wssecurity.Security;
import org.opensaml.soap.wssecurity.Timestamp;
import org.opensaml.soap.wssecurity.WSSecurityObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WsSecurityActionSupport {
    @Nonnull
    public static Security addSecurityToHeader(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Header header) {
        WSSecurityObjectBuilder builder = (WSSecurityObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Security.ELEMENT_NAME);
        Security security = (Security)builder.buildObject();
        WsSecurityActionSupport.addTimestampToSecurity(action, security);
        header.getUnknownXMLObjects().add(security);
        WsSecurityActionSupport.getLogger().debug("Action {}: Security added to a Header", (Object)action.getId());
        return security;
    }

    @Nonnull
    public static Timestamp addTimestampToSecurity(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Security security) {
        WSSecurityObjectBuilder builder = (WSSecurityObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Timestamp.ELEMENT_NAME);
        Timestamp timestamp = (Timestamp)builder.buildObject();
        WsSecurityActionSupport.addCreatedToTimestamp(action, timestamp);
        security.getUnknownXMLObjects().add(timestamp);
        WsSecurityActionSupport.getLogger().debug("Action {}: Timestamp added to the Security element", (Object)action.getId());
        return timestamp;
    }

    @Nonnull
    public static Created addCreatedToTimestamp(@Nonnull AbstractProfileAction<?, ?> action, @Nonnull Timestamp timestamp) {
        WSSecurityObjectBuilder builder = (WSSecurityObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Created.ELEMENT_NAME);
        Created created = (Created)builder.buildObject();
        created.setDateTime(new DateTime((Chronology)ISOChronology.getInstanceUTC()));
        timestamp.setCreated(created);
        WsSecurityActionSupport.getLogger().debug("Action {}: Created (with the current time) added to the Timestamp element", (Object)action.getId());
        return created;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(WsSecurityActionSupport.class);
    }
}

