/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile.ecp;

import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.idp.relyingparty.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.glite.sts.profile.saml.SamlActionSupport;
import org.glite.sts.saml.idstore.AuthnRequestIdManager;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.soap.soap11.Body;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class AddAuthnRequestToEnvelope
extends AbstractProfileAction<Object, Envelope> {
    private final Logger log = LoggerFactory.getLogger(AddAuthnRequestToEnvelope.class);
    private Function<ProfileRequestContext<?, ?>, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class, false);
    private String consumerServiceUrl;
    AuthnRequestIdManager authnRequestIdManager;

    public AddAuthnRequestToEnvelope(String consumerServiceUrl, AuthnRequestIdManager authnIdManager) {
        this.consumerServiceUrl = (String)Constraint.isNotNull((Object)consumerServiceUrl, (String)"Assertion consumer service URL cannot be empty!");
        this.authnRequestIdManager = (AuthnRequestIdManager)Constraint.isNotNull((Object)authnIdManager, (String)"Authentication request id manager cannot be null if response-to check is required!");
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Envelope> profileRequestContext) throws ProfileException {
        MessageContext outboundMessageCtx = profileRequestContext.getOutboundMessageContext();
        Envelope envelope = (Envelope)outboundMessageCtx.getMessage();
        if (envelope == null) {
            this.log.debug("Action {}: Outbound message in the context is null", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)((Object)this.relyingPartyContextLookupStrategy.apply(profileRequestContext));
        Body body = envelope.getBody();
        AuthnRequest authnRequest = SamlActionSupport.addAuthnRequestToBody(this, body);
        String id = "_" + relyingPartyCtx.getProfileConfig().getSecurityConfiguration().getIdGenerator().generateIdentifier();
        authnRequest.setID(id);
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setIssuer(SamlActionSupport.buildIssuer(this, relyingPartyCtx.getConfiguration().getResponderEntityId()));
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:PAOS");
        authnRequest.setAssertionConsumerServiceURL(this.consumerServiceUrl);
        this.authnRequestIdManager.storeAuthnRequestId(id);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }
}

