/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class SendResponseMessage
extends AbstractProfileAction<Envelope, Envelope> {
    private final Logger log = LoggerFactory.getLogger(SendResponseMessage.class);

    @Override
    protected Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Envelope> profileRequestContext) throws ProfileException {
        Element element;
        httpResponse.setContentType("text/xml");
        Envelope envelope = (Envelope)profileRequestContext.getOutboundMessageContext().getMessage();
        Marshaller marshaller = (Marshaller)XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshallers().get(Envelope.DEFAULT_ELEMENT_NAME);
        try {
            element = marshaller.marshall((XMLObject)envelope);
        }
        catch (MarshallingException e) {
            this.log.error("Could not marshall the envelope!", (Throwable)e);
            throw new ProfileException("Could not marshall the envelope!", (Exception)((Object)e));
        }
        Document document = element.getOwnerDocument();
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer serializer = domImplLS.createLSSerializer();
        LSOutput lsOutput = domImplLS.createLSOutput();
        try {
            lsOutput.setByteStream((OutputStream)httpResponse.getOutputStream());
        }
        catch (IOException e) {
            this.log.error("Could not write the output to the servlet response!", (Throwable)e);
            throw new ProfileException("Could not write the output to the servlet response!", e);
        }
        serializer.write(element, lsOutput);
        springRequestContext.getExternalContext().recordResponseComplete();
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }
}

