/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.IssueCertificate;
import org.glite.sts.ta.TokenGenerationContext;
import org.glite.sts.ta.TokenGenerationException;
import org.glite.sts.ta.TokenGenerator;
import org.glite.sts.ta.voms.VomsTokenGenerationContext;
import org.glite.sts.ta.voms.VomsTokenGenerator;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class IssueVomsProxyCertificate
extends AbstractProfileAction<Object, Object> {
    private final Logger log = LoggerFactory.getLogger(IssueCertificate.class);
    private Function<MessageContext<?>, TokenGenerationContext> tokenGenerationContextLookupStrategy = new ChildContextLookup(TokenGenerationContext.class, false);
    private Function<TokenGenerationContext, VomsTokenGenerationContext> vomsTokenGenerationContextLookupStrategy = new ChildContextLookup(VomsTokenGenerationContext.class, false);
    private TokenGenerator tokenGenerator;

    public IssueVomsProxyCertificate() {
    }

    public IssueVomsProxyCertificate(VomsTokenGenerator vomsTokenGenerator) {
        this();
        this.tokenGenerator = vomsTokenGenerator;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Object> profileRequestContext) throws ProfileException {
        TokenGenerationContext tokenGenerationContext = (TokenGenerationContext)((Object)this.tokenGenerationContextLookupStrategy.apply((Object)profileRequestContext.getOutboundMessageContext()));
        if (tokenGenerationContext == null) {
            this.log.debug("Action {}: Token generation context is null, unable to proceed", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        VomsTokenGenerationContext vomsTokenGenerationContext = (VomsTokenGenerationContext)((Object)this.vomsTokenGenerationContextLookupStrategy.apply((Object)tokenGenerationContext));
        if (vomsTokenGenerationContext == null) {
            this.log.debug("Action {}: VOMS token generation context is null, unable to proceed", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        try {
            this.tokenGenerator.issueToken(tokenGenerationContext);
        }
        catch (TokenGenerationException e) {
            this.log.error("Could not initialize the proxy certificate", (Throwable)e);
            throw new ProxyCertificateInitializationException((Throwable)e);
        }
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    public static class ProxyCertificateInitializationException
    extends ProfileException {
        private static final long serialVersionUID = -872917422123353555L;

        public ProxyCertificateInitializationException(Throwable e) {
            super(e.getMessage());
        }
    }
}

