/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.KeyAndCertCredential;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.STSException;
import org.glite.sts.profile.soap.SoapActionSupport;
import org.glite.sts.ta.TokenGenerationContext;
import org.glite.sts.ta.voms.VomsTokenGenerationContext;
import org.glite.sts.ta.x509.X509TokenGenerationContext;
import org.glite.sts.voms.xmlobject.FQAN;
import org.glite.sts.voms.xmlobject.GridProxyRequest;
import org.glite.sts.x509.RSACertificateKeys;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.wstrust.RequestSecurityToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class InitializeVomsTokenGenerationContext
extends AbstractProfileAction<Envelope, Envelope> {
    private final Logger log = LoggerFactory.getLogger(InitializeVomsTokenGenerationContext.class);
    private Function<MessageContext<Envelope>, TokenGenerationContext> tokenGenerationCtxLookupStrategy = new ChildContextLookup(TokenGenerationContext.class, false);
    private Function<TokenGenerationContext, X509TokenGenerationContext> x509TokenGenerationContextLookupStrategy = new ChildContextLookup(X509TokenGenerationContext.class, false);
    private int keysize;

    public InitializeVomsTokenGenerationContext(int strength) {
        this.keysize = strength;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Envelope> profileRequestContext) throws ProfileException {
        KeyAndCertCredential issuerCredential;
        RSACertificateKeys keys;
        MessageContext outMessageContext;
        MessageContext inMessageContext = profileRequestContext.getInboundMessageContext();
        if (inMessageContext == null) {
            this.log.debug("Action {}: inbound message context is null!", (Object)this.getId());
            ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        if ((outMessageContext = profileRequestContext.getOutboundMessageContext()) == null) {
            this.log.debug("Action {}: outbound message context is null!", (Object)this.getId());
            ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        TokenGenerationContext tokenGenerationContext = (TokenGenerationContext)((Object)this.tokenGenerationCtxLookupStrategy.apply((Object)outMessageContext));
        VomsTokenGenerationContext vomsTokenGenerationContext = new VomsTokenGenerationContext();
        RSAPublicKey publicKey = SoapActionSupport.getPublicKeyFromEnvelope(this, (Envelope)inMessageContext.getMessage());
        try {
            if (publicKey != null) {
                this.log.debug("Action {}: using the public key from the request message", (Object)this.getId());
                keys = new RSACertificateKeys(publicKey);
            } else {
                this.log.debug("Action {}: generating a new key-pair", (Object)this.getId());
                keys = new RSACertificateKeys(this.keysize);
            }
        }
        catch (STSException e) {
            this.log.error("Action {}: Could not generate a key-pair", (Object)this.getId(), (Object)e);
            throw new ProfileException("Could not generate a key-pair", e);
        }
        vomsTokenGenerationContext.setProxyKeys(keys);
        X509TokenGenerationContext x509ctx = (X509TokenGenerationContext)((Object)this.x509TokenGenerationContextLookupStrategy.apply((Object)tokenGenerationContext));
        try {
            issuerCredential = new KeyAndCertCredential(x509ctx.getCertKeys().getPrivateKey(), new X509Certificate[]{x509ctx.getCaResponse().getCertificate()});
        }
        catch (KeyStoreException e) {
            this.log.error("Action {}: Could not generate an X509Credential object from the given private key and certificate", (Object)this.getId(), (Object)e);
            throw new ProfileException("Could not generate a key-pair", e);
        }
        vomsTokenGenerationContext.setIssuerCredentials((X509Credential)issuerCredential);
        RequestSecurityToken rst = SoapActionSupport.getRequestSecurityTokenFromBody(((Envelope)inMessageContext.getMessage()).getBody());
        GridProxyRequest proxyRequest = this.getGridProxyRequestFromRST(rst);
        vomsTokenGenerationContext.setLifetime(proxyRequest.getLifetime());
        vomsTokenGenerationContext.setDelegationType(proxyRequest.getDelegationType());
        vomsTokenGenerationContext.setPolicyType("" + proxyRequest.getPolicyType());
        vomsTokenGenerationContext.setProxyType(proxyRequest.getProxyType());
        List<FQAN> fqans = proxyRequest.getVomsAttributeCertificates().getFQANs();
        vomsTokenGenerationContext.setFqans(this.parseFQANs(fqans));
        tokenGenerationContext.addSubcontext(vomsTokenGenerationContext);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected GridProxyRequest getGridProxyRequestFromRST(RequestSecurityToken rst) {
        List objects = rst.getUnknownXMLObjects(GridProxyRequest.DEFAULT_ELEMENT_NAME);
        if (objects == null || objects.size() != 1) {
            this.log.debug("Action {}: No single GridProxyRequest -element found from the RST", (Object)this.getId());
            return null;
        }
        return (GridProxyRequest)objects.get(0);
    }

    protected List<FQAN> getFQANsFromGridProxyRequest(GridProxyRequest proxyRequest) {
        return proxyRequest.getVomsAttributeCertificates().getFQANs();
    }

    protected Map<String, List<String>> parseFQANs(List<FQAN> fqans) throws ProfileException {
        HashMap<String, List<String>> requestOptions = new HashMap<String, List<String>>();
        for (int i = 0; i < fqans.size(); ++i) {
            List<String> o;
            String[] opts = fqans.get(i).getValue().split(":");
            if (opts.length != 2) {
                throw new InvalidVomsFqanStructureException(fqans.get(i));
            }
            String voName = opts[0];
            if (requestOptions.containsKey(voName)) {
                o = (List)requestOptions.get(voName);
            } else {
                o = new Vector();
                requestOptions.put(voName, o);
            }
            o.add(opts[1]);
        }
        return requestOptions;
    }

    public static class InvalidVomsFqanStructureException
    extends ProfileException {
        private static final long serialVersionUID = -872912123123872315L;

        public InvalidVomsFqanStructureException(FQAN fqan) {
            super("Could not process the FQAN " + fqan.getValue() + " in the VOMS proxy request.");
        }
    }
}

