/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.TokenRequestMessageContext;
import org.glite.sts.ta.TokenGenerationContext;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext"), @Event(id="X509TokenType"), @Event(id="X509ProxyTokenType")})
public class InitializeTokenGenerationContext
extends AbstractProfileAction<Envelope, Envelope> {
    private final Logger log = LoggerFactory.getLogger(InitializeTokenGenerationContext.class);
    public static final String EVENT_ID_X509_TOKEN_TYPE = "X509TokenType";
    public static final String EVENT_ID_X509_PROXY_TOKEN_TYPE = "X509ProxyTokenType";
    private Function<MessageContext<Envelope>, TokenRequestMessageContext> tokenRequestMessageContextLookupStrategy = new ChildContextLookup(TokenRequestMessageContext.class, false);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Envelope> profileRequestContext) throws ProfileException {
        MessageContext inMessageContext = profileRequestContext.getInboundMessageContext();
        TokenRequestMessageContext tokenRequestContext = (TokenRequestMessageContext)((Object)this.tokenRequestMessageContextLookupStrategy.apply((Object)inMessageContext));
        if (tokenRequestContext == null) {
            this.log.debug("Action {}: Token request message context is null, unable to proceed", (Object)this.getId());
            ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        MessageContext outMessageContext = profileRequestContext.getOutboundMessageContext();
        TokenGenerationContext tokenGenerationContext = new TokenGenerationContext();
        outMessageContext.addSubcontext((BaseContext)tokenGenerationContext);
        String tokenType = tokenRequestContext.getTokenType();
        tokenGenerationContext.setTokenType(tokenType);
        if (tokenType.equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-tokenprofile-1.0#X509v3")) {
            this.log.debug("Action {}: Requested token type is X.509", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, EVENT_ID_X509_TOKEN_TYPE);
        }
        if (tokenType.equals("urn:glite.org:sts:GridProxy")) {
            this.log.debug("Action {}: Requested token type is X.509 proxy", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, EVENT_ID_X509_PROXY_TOKEN_TYPE);
        }
        this.log.info("Action {}: Ignoring a request with a desired token type {}", (Object)this.getId(), (Object)tokenType);
        throw new UnSupportedOutgoingTokenTypeException(tokenType);
    }

    public static class UnSupportedOutgoingTokenTypeException
    extends ProfileException {
        private static final long serialVersionUID = -872912132137634555L;

        public UnSupportedOutgoingTokenTypeException(String tokenType) {
            super("Un-supported token type " + tokenType);
        }
    }
}

