/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.authn.CheckAssertionAuthnStatement;
import org.glite.sts.authn.CheckAssertionConditions;
import org.glite.sts.authn.CheckAssertionLifetime;
import org.glite.sts.authn.CheckAssertionSignature;
import org.glite.sts.authn.CheckAssertionSubjectConfirmation;
import org.glite.sts.authn.ExtractSamlAssertionFromWssToken;
import org.glite.sts.authn.ExtractUsernamePasswordFromWssToken;
import org.glite.sts.authn.ValidateUsernamePasswordAgainstLdap;
import org.glite.sts.profile.CheckAction;
import org.glite.sts.profile.CheckClaims;
import org.glite.sts.profile.CheckFrameworkVersion;
import org.glite.sts.profile.CheckMessageId;
import org.glite.sts.profile.CheckMessageLifetime;
import org.glite.sts.profile.CheckRecipient;
import org.glite.sts.profile.CheckRequestType;
import org.glite.sts.profile.CheckSignature;
import org.glite.sts.profile.CheckXmlSchema;
import org.glite.sts.profile.DecodeAttributesFromAssertion;
import org.glite.sts.profile.GenerateX509SubjectDn;
import org.glite.sts.profile.InitializeTokenGenerationContext;
import org.glite.sts.profile.IssueCertificate;
import org.glite.sts.profile.IssueVomsProxyCertificate;
import org.glite.sts.profile.SoapFaultContext;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.FaultCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed")})
public class InitializeSoapFaultContext
extends AbstractProfileAction<Envelope, Object> {
    private final Logger log = LoggerFactory.getLogger(InitializeSoapFaultContext.class);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Object> profileRequestContext) throws ProfileException {
        return this.generateContext(springRequestContext, null);
    }

    public org.springframework.webflow.execution.Event generateContext(RequestContext springRequestContext, Exception exception) {
        if (exception == null) {
            this.log.debug("Action {}: No exception supplied, nothing to do", (Object)this.getId());
            ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        this.log.debug("Action {}: Finding the root cause from the exception {}", (Object)this.getId(), (Object)exception.toString());
        Throwable cause = this.getRootCause(exception);
        this.log.debug("Action {}: The root cause is {}", (Object)this.getId(), (Object)cause.toString());
        ProfileRequestContext profileRequestContext = (ProfileRequestContext)((Object)this.getProfileContextLookupStrategy().apply((Object)springRequestContext));
        SoapFaultContext faultContext = this.generateSoapFaultContext(cause);
        profileRequestContext.addSubcontext(faultContext, true);
        this.log.debug("Action {}: SOAP Fault context has been added, nothing else to do.", (Object)this.getId());
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected SoapFaultContext generateSoapFaultContext(Throwable cause) {
        if (cause instanceof CheckMessageLifetime.FutureMessageException) {
            return new SoapFaultContext(FaultCode.CLIENT, "Message has been issued in the future, it cannot be accepted", "StaleMsg");
        }
        if (cause instanceof CheckMessageLifetime.PastMessageException) {
            return new SoapFaultContext(FaultCode.CLIENT, "Message has expired, it cannot be accepted", "StaleMsg");
        }
        if (cause instanceof CheckMessageLifetime.NoIssueInstantException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage(), "StaleMsg");
        }
        if (cause instanceof CheckFrameworkVersion.InvalidFrameworkVersionException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckAction.UnSupportedActionException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckRequestType.UnSupportedWsTrustRequestTypeException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof InitializeTokenGenerationContext.UnSupportedOutgoingTokenTypeException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckClaims.UnSupportedIncomingTokenTypeException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckAssertionLifetime.FutureAssertionException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckAssertionLifetime.PastAssertionException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof IssueCertificate.CertificateIssuanceException) {
            return new SoapFaultContext(FaultCode.SERVER, "Could not obtain X.509 certificate from the online CA", "CAClient", cause.getMessage());
        }
        if (cause instanceof IssueVomsProxyCertificate.ProxyCertificateInitializationException) {
            return new SoapFaultContext(FaultCode.SERVER, "Could not initialize the proxy", "VomsProxyInit", cause.getMessage());
        }
        if (cause instanceof CheckXmlSchema.SchemaInvalidXmlMessageException) {
            return new SoapFaultContext(FaultCode.CLIENT, "Incoming message had invalid schema!", "Schema", cause.getMessage());
        }
        if (cause instanceof CheckAssertionSignature.InvalidAssertionSignatureException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof ValidateUsernamePasswordAgainstLdap.InvalidUsernamePasswordException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckAssertionSubjectConfirmation.InvalidSubjectConfirmationException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof GenerateX509SubjectDn.SubjectDnCreationException) {
            return new SoapFaultContext(FaultCode.SERVER, cause.getMessage());
        }
        if (cause instanceof CheckAssertionConditions.NotInAssertionAudienceException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckAssertionConditions.NotYetValidAssertionException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckAssertionConditions.ExpiredAssertionException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof ExtractUsernamePasswordFromWssToken.NonParsableUsernamePasswordException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof ExtractSamlAssertionFromWssToken.NonParsableSamlAssertionException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckRecipient.InvalidRecipientException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckMessageId.NoMessageIdFoundException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckAssertionConditions.NoConditionsInAssertionException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckAssertionLifetime.NoIssueInstantException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckAssertionAuthnStatement.InvalidRemoteAddressInAssertionException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckAssertionAuthnStatement.FutureAuthnInstantInAssertionException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckAssertionAuthnStatement.PastAuthnInstantInAssertionException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckAssertionAuthnStatement.NoSingleAuthnStatementInAssertionException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof CheckSignature.InvalidSignatureException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        if (cause instanceof DecodeAttributesFromAssertion.UnSupportedAttributeValueTypeException) {
            return new SoapFaultContext(FaultCode.CLIENT, cause.getMessage());
        }
        this.log.debug("Action {}: Exception is not identified", (Object)this.getId());
        return new SoapFaultContext(FaultCode.SERVER, "Internal server error");
    }

    protected Throwable getRootCause(Exception exception) {
        Throwable cause = exception;
        while ((cause = cause.getCause()).getCause() != null) {
        }
        return cause;
    }
}

