/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.attribute.AttributeContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.glite.sts.ta.TokenGenerationContext;
import org.glite.sts.ta.x509.X509TokenGenerationContext;
import org.glite.sts.x509.dn.DNBuilder;
import org.glite.sts.x509.dn.DNBuildingException;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidProfileContext"), @Event(id="InvalidAttributeContext")})
public class GenerateX509SubjectDn
extends AbstractProfileAction<Envelope, Envelope> {
    private final Logger log = LoggerFactory.getLogger(GenerateX509SubjectDn.class);
    private DNBuilder dnBuilder;
    private Function<MessageContext<?>, TokenGenerationContext> tokenGenerationContextLookupStrategy = new ChildContextLookup(TokenGenerationContext.class, false);
    private Function<TokenGenerationContext, X509TokenGenerationContext> x509TokenGenerationContextLookupStrategy = new ChildContextLookup(X509TokenGenerationContext.class, false);
    private Function<ProfileRequestContext<?, ?>, AttributeContext> attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class, false);

    public GenerateX509SubjectDn() {
    }

    public GenerateX509SubjectDn(DNBuilder dnBuilder) {
        this();
        this.dnBuilder = (DNBuilder)Constraint.isNotNull((Object)dnBuilder, (String)"The subject DN builder cannot be null!");
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Envelope> profileRequestContext) throws ProfileException {
        String subjectDn;
        TokenGenerationContext tokenGenerationContext = (TokenGenerationContext)((Object)this.tokenGenerationContextLookupStrategy.apply((Object)profileRequestContext.getOutboundMessageContext()));
        if (tokenGenerationContext == null) {
            this.log.debug("Action {}: Token generation context is null, unable to proceed", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidProfileContext");
        }
        X509TokenGenerationContext x509TokenGenerationContext = (X509TokenGenerationContext)((Object)this.x509TokenGenerationContextLookupStrategy.apply((Object)tokenGenerationContext));
        if (x509TokenGenerationContext == null) {
            this.log.debug("Action {}: X.509 token generation context is null, unable to proceed", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidProfileContext");
        }
        AttributeContext attributeContext = (AttributeContext)((Object)this.attributeContextLookupStrategy.apply(profileRequestContext));
        if (attributeContext == null) {
            this.log.debug("Action {}: Attribute context is null, unable to proceed", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidProfileContext");
        }
        try {
            subjectDn = this.dnBuilder.createDN(attributeContext);
        }
        catch (DNBuildingException e) {
            this.log.debug("Could not build the subject DN for the upcoming certificate", (Throwable)e);
            throw new SubjectDnCreationException("Could not generate the subject DN from the set of available attributes!");
        }
        x509TokenGenerationContext.setSubjectDN(subjectDn);
        this.log.debug("Action {}: Using {} as the subject DN", (Object)this.getId(), (Object)subjectDn);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    public static class SubjectDnCreationException
    extends ProfileException {
        private static final long serialVersionUID = -872917123123634555L;

        public SubjectDnCreationException(String message) {
            super(message);
        }
    }
}

