/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.profile.HttpServletRequestMessageDecoderFactory;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.glite.sts.profile.EnvelopeDecoder;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvelopeDecoderFactory
implements HttpServletRequestMessageDecoderFactory<Envelope> {
    private final Logger log = LoggerFactory.getLogger(EnvelopeDecoderFactory.class);
    private final ParserPool parserPool;

    public EnvelopeDecoderFactory(@Nonnull ParserPool pool) {
        this.parserPool = (ParserPool)Constraint.isNotNull((Object)pool, (String)"Parser pool can not be null");
    }

    @Override
    public MessageDecoder<Envelope> newDecoder(HttpServletRequest httpRequest) throws MessageDecodingException {
        this.log.debug("Constructing a new EnvelopeDecoder..");
        EnvelopeDecoder decoder = new EnvelopeDecoder();
        decoder.setHttpServletRequest(httpRequest);
        decoder.setParserPool(this.parserPool);
        try {
            decoder.initialize();
        }
        catch (ComponentInitializationException e) {
            this.log.error("Could not initialize the EnvelopeDecorder!", (Throwable)e);
        }
        return decoder;
    }
}

