/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext", description="No inbound message context or message")})
public class CheckXmlSchema
extends AbstractProfileAction<XMLObject, Object> {
    private Logger log = LoggerFactory.getLogger(CheckXmlSchema.class);
    private final Schema validationSchema;

    public CheckXmlSchema(@Nonnull Schema schema) {
        this.validationSchema = (Schema)Constraint.isNotNull((Object)schema, (String)"Schema can not be null");
    }

    @Nonnull
    public Schema getValidationSchema() {
        return this.validationSchema;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<XMLObject, Object> profileRequestContext) throws ProfileException {
        this.log.debug("Action {}: Attempting to schema validate incoming message", (Object)this.getId());
        MessageContext msgCtx = profileRequestContext.getInboundMessageContext();
        if (msgCtx == null) {
            this.log.debug("Action {}: Inbound message context is null, unable to proceed", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        XMLObject request = (XMLObject)msgCtx.getMessage();
        if (request == null) {
            this.log.debug("Action {}: Inbound message context did not contain a message, unable to proceed", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        Element requestElem = request.getDOM();
        if (requestElem == null) {
            this.log.debug("Action {}: Inbound message doesn't contain a DOM, unable to proceed", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        try {
            Validator schemaValidator = this.validationSchema.newValidator();
            schemaValidator.validate(new DOMSource(requestElem));
        }
        catch (SAXException e) {
            this.log.debug("Action {}: Incoming request {} is not schema valid", new Object[]{this.getId(), request.getElementQName(), e});
            throw new SchemaInvalidXmlMessageException(e.getMessage());
        }
        catch (IOException e) {
            this.log.debug("Action {}: Unable to read incoming message");
            throw new SchemaInvalidXmlMessageException(e.getMessage());
        }
        this.log.debug("Action {}: Incoming message is valid", (Object)this.getId());
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    public static class SchemaInvalidXmlMessageException
    extends ProfileException {
        private static final long serialVersionUID = -7012312349423732050L;

        public SchemaInvalidXmlMessageException(String message) {
            super("Schema validation error: " + message);
        }
    }
}

