/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.CheckAction;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wsaddressing.To;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed")})
public class CheckRecipient
extends AbstractProfileAction<Envelope, Object> {
    private final Logger log = LoggerFactory.getLogger(CheckAction.class);
    private String recipientId;

    public CheckRecipient(String expectedId) {
        this.recipientId = expectedId;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Object> profileRequestContext) throws ProfileException {
        Envelope envelope = (Envelope)profileRequestContext.getInboundMessageContext().getMessage();
        String recipient = this.getRecipientFromEnvelope(envelope);
        if (this.recipientId == null) {
            this.log.debug("Action {}: Recipient is not required.", (Object)this.getId());
        } else if (!this.recipientId.equals(recipient)) {
            this.log.warn("Action {}: Ignoring the request, wrong target ({})", (Object)this.getId(), (Object)recipient);
            throw new InvalidRecipientException("This envelope is not targeted to this STS!");
        }
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected String getRecipientFromEnvelope(Envelope envelope) throws ProfileException {
        Header header = envelope.getHeader();
        if (header == null) {
            throw new ProfileException("Header was not found from the envelope!");
        }
        List objects = header.getUnknownXMLObjects(To.ELEMENT_NAME);
        if (objects.size() == 1) {
            To recipient = (To)objects.get(0);
            return recipient.getValue();
        }
        throw new ProfileException("No single To -element found from the envelope header!");
    }

    public static class InvalidRecipientException
    extends ProfileException {
        private static final long serialVersionUID = -872917213127634555L;

        public InvalidRecipientException(String message) {
            super(message);
        }
    }
}

