/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.idp.relyingparty.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.BasicMessageMetadataContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public final class CheckMessageLifetime
extends AbstractProfileAction<Object, Object> {
    private final Logger log = LoggerFactory.getLogger(CheckMessageLifetime.class);
    private long messageLifetime;
    private boolean requireIssueInstant;
    private Function<ProfileRequestContext<Object, Object>, RelyingPartyContext> rpContextLookupStrategy;
    private Function<MessageContext<Object>, BasicMessageMetadataContext> messageMetadataContextLookupStrategy;

    public CheckMessageLifetime(boolean issueInstantRequired) {
        this(issueInstantRequired, TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES));
    }

    public CheckMessageLifetime(boolean issueInstantRequired, long lifetime) {
        this.requireIssueInstant = issueInstantRequired;
        this.messageLifetime = lifetime;
        this.rpContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class, false);
        this.messageMetadataContextLookupStrategy = new ChildContextLookup(BasicMessageMetadataContext.class, false);
    }

    @Override
    protected Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Object> profileRequestContext) throws ProfileException {
        long currentTime;
        if (!this.requireIssueInstant) {
            this.log.debug("Action {}: No issue instant required, ignoring the lifetime check!", (Object)this.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)((Object)this.rpContextLookupStrategy.apply(profileRequestContext));
        BasicMessageMetadataContext messageSubcontext = (BasicMessageMetadataContext)this.messageMetadataContextLookupStrategy.apply((Object)profileRequestContext.getInboundMessageContext());
        if (messageSubcontext.getMessageIssueInstant() <= 0L) {
            throw new NoIssueInstantException(messageSubcontext.getMessageId());
        }
        long clockskew = relyingPartyCtx.getProfileConfig().getSecurityConfiguration().getClockSkew();
        long issueInstant = messageSubcontext.getMessageIssueInstant();
        if (issueInstant < (currentTime = System.currentTimeMillis()) - clockskew) {
            throw new PastMessageException(messageSubcontext.getMessageId(), issueInstant);
        }
        if (issueInstant > currentTime + this.messageLifetime + clockskew) {
            throw new FutureMessageException(messageSubcontext.getMessageId(), issueInstant);
        }
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    public class NoIssueInstantException
    extends ProfileException {
        private static final long serialVersionUID = 18935321312306635L;

        public NoIssueInstantException(String messageId) {
            super("Action " + CheckMessageLifetime.this.getId() + ": Message " + messageId + " had no issue instant, even though it's required!");
        }
    }

    public class PastMessageException
    extends ProfileException {
        private static final long serialVersionUID = 18935109782906635L;

        public PastMessageException(String messageId, long instant) {
            super("Action " + CheckMessageLifetime.this.getId() + ": Message " + messageId + " was issued on " + new DateTime(instant).toString() + " is now considered expired.");
        }
    }

    public class FutureMessageException
    extends ProfileException {
        private static final long serialVersionUID = -6474772810189615621L;

        public FutureMessageException(String messageId, long instant) {
            super("Action " + CheckMessageLifetime.this.getId() + ": Message " + messageId + " was issued on " + new DateTime(instant).toString() + " and is not yet valid.");
        }
    }
}

