/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wsaddressing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidProfileContext")})
public class CheckAction
extends AbstractProfileAction<Envelope, Object> {
    private final Logger log = LoggerFactory.getLogger(CheckAction.class);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Envelope, Object> profileRequestContext) throws ProfileException {
        Envelope envelope = (Envelope)profileRequestContext.getInboundMessageContext().getMessage();
        Header header = envelope.getHeader();
        if (header == null) {
            this.log.error("Action {}: Header was not found from the envelope!", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidProfileContext");
        }
        String action = this.getActionFromEnvelopeHeader(header);
        if (!"http://docs.oasis-open.org/ws-sx/ws-trust/200512/RST/Issue".equals(action)) {
            this.log.warn("Action {}: Ignoring an {} operation request.", (Object)this.getId(), (Object)action);
            throw new UnSupportedActionException(action);
        }
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected String getActionFromEnvelopeHeader(Header header) throws ProfileException {
        List objects = header.getUnknownXMLObjects(Action.ELEMENT_NAME);
        if (objects.size() == 1) {
            Action action = (Action)objects.get(0);
            return action.getValue();
        }
        throw new ProfileException("No single Action element found from the envelope header!");
    }

    public static class UnSupportedActionException
    extends ProfileException {
        private static final long serialVersionUID = -872763232432124555L;

        public UnSupportedActionException(String action) {
            super("Action " + action + " is not supported!");
        }
    }
}

