/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.bouncycastle.util.encoders.Base64;
import org.glite.sts.profile.wstrust.WsTrustActionSupport;
import org.glite.sts.ta.TokenGenerationContext;
import org.glite.sts.ta.voms.VomsTokenGenerationContext;
import org.glite.sts.ta.x509.X509TokenGenerationContext;
import org.glite.sts.x509.CertificateKeys;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.wstrust.BinarySecret;
import org.opensaml.soap.wstrust.RequestSecurityTokenResponse;
import org.opensaml.soap.wstrust.RequestSecurityTokenResponseCollection;
import org.opensaml.soap.wstrust.RequestedProofToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class AddSecurityProofToRSTR
extends AbstractProfileAction<Object, Envelope> {
    private final Logger log = LoggerFactory.getLogger(AddSecurityProofToRSTR.class);
    private Function<MessageContext<?>, TokenGenerationContext> tokenGenerationContextLookupStrategy = new ChildContextLookup(TokenGenerationContext.class, false);
    private Function<TokenGenerationContext, X509TokenGenerationContext> x509TokenGenerationContextLookupStrategy = new ChildContextLookup(X509TokenGenerationContext.class, false);
    private Function<TokenGenerationContext, VomsTokenGenerationContext> vomsTokenGenerationContextLookupStrategy = new ChildContextLookup(VomsTokenGenerationContext.class, false);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Envelope> profileRequestContext) throws ProfileException {
        this.log.debug("Action {}: Attempting to add a proof token to outgoing RSTR inside an Envelope", (Object)this.getId());
        Envelope envelope = (Envelope)profileRequestContext.getOutboundMessageContext().getMessage();
        if (envelope == null) {
            this.log.debug("Action {}: Envelope was not found from the outbound context.", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        TokenGenerationContext tokenGenerationCtx = (TokenGenerationContext)((Object)this.tokenGenerationContextLookupStrategy.apply((Object)profileRequestContext.getOutboundMessageContext()));
        if (tokenGenerationCtx == null) {
            this.log.debug("Action {}: No TokenGenerationContext available, nothing left to do", (Object)this.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        VomsTokenGenerationContext vomsContext = (VomsTokenGenerationContext)((Object)this.vomsTokenGenerationContextLookupStrategy.apply((Object)tokenGenerationCtx));
        if (vomsContext != null) {
            this.log.debug("Action {}: VomsTokenGenerationContext is available for TokenGenerationContext{}", (Object)this.getId(), (Object)tokenGenerationCtx.getId());
            CertificateKeys proxyKeys = vomsContext.getProxyKeys();
            if (proxyKeys == null || proxyKeys.getPrivateKey() == null) {
                this.log.debug("Action {}: No private key available in the proxy credentials, nothing left to do", (Object)this.getId());
                return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
            }
            this.encodePrivateKeyToRSTR(envelope, vomsContext.getProxyKeys().getPrivateKey());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        X509TokenGenerationContext x509Context = (X509TokenGenerationContext)((Object)this.x509TokenGenerationContextLookupStrategy.apply((Object)tokenGenerationCtx));
        if (x509Context == null) {
            this.log.debug("Action {}: No X509TokenGenerationContext available for TokenGenerationContext {}, nothing left to do", (Object)this.getId(), (Object)tokenGenerationCtx.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        if (x509Context.getCaResponse() == null || x509Context.getCaResponse().getCertificate() == null) {
            this.log.debug("Action {}: No corresponding certificate available for proof, nothing left to do", (Object)this.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        CertificateKeys certKeys = x509Context.getCertKeys();
        if (certKeys == null || certKeys.getPrivateKey() == null) {
            this.log.debug("Action {}: No private key available in the certificate keys, nothing left to do", (Object)this.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        this.encodePrivateKeyToRSTR(envelope, certKeys.getPrivateKey());
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected void encodePrivateKeyToRSTR(Envelope envelope, PrivateKey privateKey) {
        RequestSecurityTokenResponseCollection rstrc = (RequestSecurityTokenResponseCollection)envelope.getBody().getUnknownXMLObjects(RequestSecurityTokenResponseCollection.ELEMENT_NAME).get(0);
        RequestSecurityTokenResponse rstr = (RequestSecurityTokenResponse)rstrc.getRequestSecurityTokenResponses().get(0);
        RequestedProofToken proofToken = WsTrustActionSupport.addRequestedProofTokenToRSTR(this, rstr);
        BinarySecret secret = WsTrustActionSupport.addBinarySecretToProofToken(this, proofToken);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            CertificateUtils.savePrivateKey((OutputStream)baos, (PrivateKey)privateKey, (CertificateUtils.Encoding)CertificateUtils.Encoding.DER, null, null);
        }
        catch (Exception e) {
            this.log.warn("Action {}: Could not encode Private Key, nothing left to do", (Object)this.getId(), (Object)e);
            return;
        }
        String proof = new String(Base64.encode((byte[])baos.toByteArray()));
        secret.setType("http://docs.oasis-open.org/ws-sx/ws-trust/200512/AsymmetricKey");
        secret.setValue(proof);
    }
}

