/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.glite.sts.profile.soap.SoapActionSupport;
import org.opensaml.messaging.context.BasicMessageMetadataContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class AddRelatesToToEnvelope
extends AbstractProfileAction<Object, Envelope> {
    private Logger log = LoggerFactory.getLogger(AddRelatesToToEnvelope.class);
    private Function<MessageContext<?>, BasicMessageMetadataContext> messageMetadataContextLookupStrategy = new ChildContextLookup(BasicMessageMetadataContext.class, false);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Envelope> profileRequestContext) throws ProfileException {
        MessageContext outboundMessageCtx = profileRequestContext.getOutboundMessageContext();
        Envelope envelope = (Envelope)outboundMessageCtx.getMessage();
        if (envelope == null) {
            this.log.debug("Action {}: Outbound message in the context is null", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        Header header = envelope.getHeader();
        BasicMessageMetadataContext messageSubcontext = (BasicMessageMetadataContext)this.messageMetadataContextLookupStrategy.apply((Object)profileRequestContext.getInboundMessageContext());
        String requestId = StringSupport.trimOrNull((String)messageSubcontext.getMessageId());
        if (requestId == null) {
            this.log.debug("Action {}: No message id found from the message metadata", (Object)this.getId());
            SoapActionSupport.addRelatesToToHeader(this, header, "<no_id_found>");
        } else {
            this.log.debug("Action {}: Outgoing message is related to {}", (Object)this.getId(), (Object)requestId);
            SoapActionSupport.addRelatesToToHeader(this, header, requestId);
        }
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }
}

