/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.profile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.profile.wstrust.WsTrustActionSupport;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed"), @Event(id="InvalidMessageContext")})
public class AddRSTRCToEnvelope
extends AbstractProfileAction<Object, Envelope> {
    private final Logger log = LoggerFactory.getLogger(AddRSTRCToEnvelope.class);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext<Object, Envelope> profileRequestContext) throws ProfileException {
        this.log.debug("Action {}: Attempting to add an RSTRC object to outgoing Envelope", (Object)this.getId());
        Envelope envelope = (Envelope)profileRequestContext.getOutboundMessageContext().getMessage();
        if (envelope == null) {
            this.log.debug("Action {}: Envelope was not found from the outbound context.", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidMessageContext");
        }
        WsTrustActionSupport.addRSTRCtoEnvelopeBody(this, envelope);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }
}

