/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import net.shibboleth.idp.service.AbstractReloadableService;
import net.shibboleth.idp.service.ServiceException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentValidationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.resource.ResourceException;
import org.slf4j.LoggerFactory;

public class LogbackLoggingService
extends AbstractReloadableService {
    private LoggerContext loggerContext;
    private StatusManager statusManager;
    private URL fallbackConfiguraiton;
    private Resource configurationResource;

    public LogbackLoggingService(Resource configuration) throws ServiceException {
        this.configurationResource = (Resource)Constraint.isNotNull((Object)configuration, (String)"Configuration resource cannot be null!");
        try {
            this.doInitialize();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
        this.loadLoggingConfiguration();
    }

    public Resource getLoggingConfiguration() {
        return this.configurationResource;
    }

    public synchronized void setLoggingConfiguration(Resource configuration) {
        if (this.isInitialized()) {
            return;
        }
        this.configurationResource = configuration;
    }

    @Override
    public void validate() throws ComponentValidationException {
        try {
            if (!this.configurationResource.exists()) {
                throw new ComponentValidationException("Logging service configuration resource " + this.configurationResource.getLocation() + " does not exist.");
            }
        }
        catch (ResourceException e) {
            throw new ComponentValidationException("Unable to determing if logging service configuration resource " + this.configurationResource.getLocation(), (Exception)((Object)e));
        }
    }

    @Override
    protected boolean shouldReload() {
        try {
            return this.configurationResource.getLastModifiedTime() > this.getLastSuccessfulReloadInstant().getMillis();
        }
        catch (ResourceException e) {
            this.statusManager.add((Status)new ErrorStatus("Error checking last modified time of logging service configuration resource " + this.configurationResource.getLocation(), (Object)this, (Throwable)e));
            return false;
        }
    }

    @Override
    protected void doReload(HashMap context) throws ServiceException {
        super.doReload(context);
        this.loadLoggingConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLoggingConfiguration() throws ServiceException {
        InputStream ins = null;
        try {
            this.statusManager.add((Status)new InfoStatus("Loading new logging configuration resource: " + this.configurationResource.getLocation(), (Object)this));
            ins = this.configurationResource.getInputStream();
            this.loadLoggingConfiguration(ins);
        }
        catch (Exception e) {
            try {
                Closeables.closeQuietly(ins);
                this.statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + this.configurationResource.getLocation(), (Object)this, (Throwable)e));
                try {
                    this.statusManager.add((Status)new InfoStatus("Loading fallback logging configuration", (Object)this));
                    ins = this.fallbackConfiguraiton.openStream();
                    this.loadLoggingConfiguration(ins);
                }
                catch (IOException ioe) {
                    Closeables.closeQuietly((Closeable)ins);
                    this.statusManager.add((Status)new ErrorStatus("Error loading fallback logging configuration", (Object)this, (Throwable)e));
                    throw new ServiceException("Unable to load fallback logging configuration");
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(ins);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)ins);
        }
        Closeables.closeQuietly((Closeable)ins);
    }

    protected void loadLoggingConfiguration(InputStream loggingConfig) throws ServiceException {
        try {
            this.loggerContext.reset();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)this.loggerContext);
            configurator.doConfigure(loggingConfig);
            this.loggerContext.start();
        }
        catch (JoranException e) {
            throw new ServiceException((Exception)((Object)e));
        }
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        if (this.configurationResource == null) {
            throw new ComponentInitializationException("Logging configuration must be specified.");
        }
        this.fallbackConfiguraiton = LogbackLoggingService.class.getResource("/logback.xml");
        this.loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.statusManager = this.loggerContext.getStatusManager();
    }
}

