/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.config;

import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.ldaptive.pool.BlockingConnectionPool;
import org.ldaptive.pool.PoolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LdapConfigurationValidator
extends AbstractInitializableComponent
implements ApplicationContextAware {
    private final Logger log = LoggerFactory.getLogger(LdapConfigurationValidator.class);
    private boolean ldapEnabled;
    private ApplicationContext springApplicationContext;

    public LdapConfigurationValidator(boolean enableLdap) {
        this.ldapEnabled = enableLdap;
    }

    public void doInitialize() throws ComponentInitializationException {
        if (this.ldapEnabled) {
            this.log.debug("LDAP is enabled, verifying the connection.");
            BlockingConnectionPool pool = (BlockingConnectionPool)this.springApplicationContext.getBean("stsLdapPool", BlockingConnectionPool.class);
            try {
                pool.getConnection();
            }
            catch (PoolException e) {
                this.log.error("Could not get a connection from the LDAP connection pool", (Throwable)e);
                throw new ComponentInitializationException("Could not get a connection from the LDAP connection pool", (Exception)((Object)e));
            }
        } else {
            this.log.debug("LDAP is not enabled, ignoring the configuration verification.");
        }
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.springApplicationContext = appContext;
    }
}

