/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.authn;

import com.google.common.base.Function;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationException;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.glite.sts.authn.UsernamePasswordContext;
import org.glite.sts.profile.TokenRequestMessageContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wssecurity.Password;
import org.opensaml.soap.wssecurity.Security;
import org.opensaml.soap.wssecurity.Username;
import org.opensaml.soap.wssecurity.UsernameToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ExtractUsernamePasswordFromWssToken
extends AbstractAuthenticationAction {
    public static final String PASSWORD_DIGEST = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
    public static final String PASSWORD_TEXT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
    private final Logger log = LoggerFactory.getLogger(ExtractUsernamePasswordFromWssToken.class);
    private Function<MessageContext<Envelope>, TokenRequestMessageContext> tokenRequestMessageContextLookupStrategy = new ChildContextLookup(TokenRequestMessageContext.class, false);

    @Override
    protected Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext profileRequestContext, AuthenticationRequestContext authenticationContext) throws AuthenticationException {
        MessageContext messageContext = profileRequestContext.getInboundMessageContext();
        TokenRequestMessageContext tokenRequestContext = (TokenRequestMessageContext)((Object)this.tokenRequestMessageContextLookupStrategy.apply((Object)messageContext));
        String tokenReferenceUri = tokenRequestContext.getTokenReference();
        if (!tokenReferenceUri.substring(0, 1).equals("#")) {
            this.log.debug("Action {}: Could not parse the SecurityReference: the URI should start with '#'!", (Object)this.getId());
            throw new NonParsableUsernamePasswordException("Could not parse the SecurityReference: the URI should start with '#'!");
        }
        Envelope inboundMessage = (Envelope)messageContext.getMessage();
        UsernameToken usernameToken = this.getUsernameToken(inboundMessage, tokenReferenceUri.substring(1));
        UsernamePasswordContext usernameContext = (UsernamePasswordContext)authenticationContext.getSubcontext(UsernamePasswordContext.class, true);
        this.extractUsernamePassword(usernameToken, usernameContext);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    private UsernameToken getUsernameToken(Envelope message, String tokenReference) throws AuthenticationException {
        this.log.debug("Action {}: Looking for the username token with id {}", (Object)this.getId(), (Object)tokenReference);
        Header header = message.getHeader();
        List objects = header.getUnknownXMLObjects(Security.ELEMENT_NAME);
        if (objects.size() != 1) {
            throw new AuthenticationException("More than one security elements in the header!");
        }
        if ((objects = ((Security)objects.get(0)).getUnknownXMLObjects(UsernameToken.ELEMENT_NAME)).size() != 1) {
            throw new NonParsableUsernamePasswordException("No single UsernameToken found in the security headers!");
        }
        UsernameToken usernameToken = (UsernameToken)objects.get(0);
        if (tokenReference.equals(usernameToken.getWSUId())) {
            return usernameToken;
        }
        throw new NonParsableUsernamePasswordException("No UsernameToken with id=" + tokenReference + " found in the security headers!");
    }

    private void extractUsernamePassword(UsernameToken usernameToken, UsernamePasswordContext usernameContext) throws AuthenticationException {
        Username username = usernameToken.getUsername();
        if (username == null || StringSupport.trimOrNull((String)username.getValue()) == null) {
            throw new NonParsableUsernamePasswordException("Could not extract username from the token");
        }
        List passwords = usernameToken.getUnknownXMLObjects(Password.ELEMENT_NAME);
        if (passwords.size() != 1) {
            throw new NonParsableUsernamePasswordException("Not one single password elements found from the token");
        }
        Password password = (Password)passwords.get(0);
        if (password.getType() == null || StringSupport.trimOrNull((String)password.getValue()) == null) {
            throw new NonParsableUsernamePasswordException("Could not get the password value from the token");
        }
        usernameContext.setUsername(username.getValue()).setPassword(password.getValue());
        if (password.getType().equals(PASSWORD_DIGEST)) {
            this.log.debug("Setting the password digest to true");
            usernameContext.setDigest(true);
        } else if (password.getType().equals(PASSWORD_TEXT)) {
            this.log.debug("Setting the password digest to false");
            usernameContext.setDigest(false);
        } else {
            this.log.warn("Unsupported password type {}", (Object)password.getType());
            throw new NonParsableUsernamePasswordException("Unsupported password type in the token!");
        }
    }

    public class NonParsableUsernamePasswordException
    extends AuthenticationException {
        private static final long serialVersionUID = 6474772810183235231L;

        public NonParsableUsernamePasswordException(String message) {
            super(message);
        }
    }
}

