/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.authn;

import com.google.common.base.Function;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationException;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.authn.AssertionContext;
import org.glite.sts.profile.TokenRequestMessageContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.wssecurity.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed")})
public class ExtractSamlAssertionFromWssToken
extends AbstractAuthenticationAction {
    private final Logger log = LoggerFactory.getLogger(ExtractSamlAssertionFromWssToken.class);
    private Function<MessageContext<Envelope>, TokenRequestMessageContext> tokenRequestMessageContextLookupStrategy = new ChildContextLookup(TokenRequestMessageContext.class, false);

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext profileRequestContext, AuthenticationRequestContext authenticationContext) throws AuthenticationException {
        this.log.debug("Action {}: Extracting a SAML assertion from the Envelope", (Object)this.getId());
        MessageContext messageContext = profileRequestContext.getInboundMessageContext();
        TokenRequestMessageContext tokenRequestContext = (TokenRequestMessageContext)((Object)this.tokenRequestMessageContextLookupStrategy.apply((Object)messageContext));
        String tokenReferenceUri = tokenRequestContext.getTokenReference();
        if (!tokenReferenceUri.substring(0, 1).equals("#")) {
            this.log.debug("Action {}: Could not parse the SecurityReference: the URI should start with '#'!", (Object)this.getId());
            throw new NonParsableSamlAssertionException("Could not parse the SecurityReference: the URI should start with '#'!");
        }
        Envelope envelope = (Envelope)messageContext.getMessage();
        Assertion assertion = this.getAssertion(envelope, tokenReferenceUri.substring(1));
        ((AssertionContext)authenticationContext.getSubcontext(AssertionContext.class, true)).setAssertion(assertion);
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    private Assertion getAssertion(Envelope message, String tokenReference) throws AuthenticationException {
        Header header = message.getHeader();
        List objects = header.getUnknownXMLObjects(Security.ELEMENT_NAME);
        if (objects.size() != 1) {
            this.log.debug("Action {}: More than one security elements in the header!", (Object)this.getId());
            throw new AuthenticationException("More than one security elements in the header!");
        }
        if ((objects = ((Security)objects.get(0)).getUnknownXMLObjects(Assertion.DEFAULT_ELEMENT_NAME)) == null || objects.size() != 1) {
            this.log.debug("Action {}: Invalid amount of assertions in the security header!", (Object)this.getId());
            throw new NonParsableSamlAssertionException("Invalid amount of assertions in the security header!");
        }
        this.log.debug("Action {}: Found one SAML assertion.", (Object)this.getId());
        Assertion assertion = (Assertion)objects.get(0);
        if (tokenReference.equals(assertion.getID())) {
            return assertion;
        }
        throw new NonParsableSamlAssertionException("No assertion with the id=" + tokenReference + " found!");
    }

    public class NonParsableSamlAssertionException
    extends AuthenticationException {
        private static final long serialVersionUID = 6474772810183235231L;

        public NonParsableSamlAssertionException(String message) {
            super(message);
        }
    }
}

