/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.authn;

import com.google.common.base.Function;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationException;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.authn.AssertionContext;
import org.glite.sts.saml.TrustedIdpMetadataService;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed")})
public class CheckAssertionSignature
extends AbstractAuthenticationAction {
    private final Logger log = LoggerFactory.getLogger(CheckAssertionSignature.class);
    private TrustedIdpMetadataService idpMetadata;
    private Function<AuthenticationRequestContext, AssertionContext> assertionCtxLookupStrategy = new ChildContextLookup(AssertionContext.class, false);

    public CheckAssertionSignature(TrustedIdpMetadataService metadataService) {
        this.idpMetadata = metadataService;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext profileRequestContext, AuthenticationRequestContext authenticationContext) throws AuthenticationException {
        Assertion assertion = ((AssertionContext)((Object)this.assertionCtxLookupStrategy.apply((Object)authenticationContext))).getAssertion();
        String entityId = assertion.getIssuer().getValue();
        this.log.debug("Action {}: Verifying the assertion provided by {}", (Object)this.getId(), (Object)entityId);
        Credential idpCredential = this.idpMetadata.getCredential(entityId);
        if (!this.signatureValidated(assertion.getSignature(), idpCredential, entityId)) {
            throw new InvalidAssertionSignatureException(assertion.getID(), entityId);
        }
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected boolean signatureValidated(Signature signature, Credential validatingCredential, String entityId) {
        SignatureValidator validator = new SignatureValidator(validatingCredential);
        try {
            validator.validate(signature);
        }
        catch (SignatureException e) {
            this.log.warn("The signature could not be validated for {}", (Object)entityId);
            this.log.debug("The stack for the failure", (Throwable)e);
            return false;
        }
        return true;
    }

    public class InvalidAssertionSignatureException
    extends AuthenticationException {
        private static final long serialVersionUID = 6474772810183231233L;

        public InvalidAssertionSignatureException(String assertionId, String entityId) {
            super("Signature in assertion " + assertionId + ", issued by " + entityId + " could not be validated.");
        }
    }
}

