/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.authn;

import com.google.common.base.Function;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationException;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.idp.relyingparty.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import org.glite.sts.authn.AssertionContext;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.saml.saml2.core.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed")})
public class CheckAssertionLifetime
extends AbstractAuthenticationAction {
    private final Logger log = LoggerFactory.getLogger(CheckAssertionLifetime.class);
    private long assertionLifetime;
    private Function<AuthenticationRequestContext, AssertionContext> assertionCtxLookupStrategy;
    private Function<ProfileRequestContext<?, ?>, RelyingPartyContext> rpContextLookupStrategy;

    public CheckAssertionLifetime(int assertionLifetimeInMinutes) {
        this.assertionLifetime = TimeUnit.MILLISECONDS.convert(assertionLifetimeInMinutes, TimeUnit.MINUTES);
        this.assertionCtxLookupStrategy = new ChildContextLookup(AssertionContext.class, false);
        this.rpContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class, false);
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext profileRequestContext, AuthenticationRequestContext authenticationContext) throws AuthenticationException {
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)((Object)this.rpContextLookupStrategy.apply((Object)profileRequestContext));
        Assertion assertion = ((AssertionContext)((Object)this.assertionCtxLookupStrategy.apply((Object)authenticationContext))).getAssertion();
        long issueInstant = assertion.getIssueInstant().getMillis();
        if (issueInstant <= 0L) {
            this.log.debug("Action {}: No issue instant found", (Object)this.getId());
            throw new NoIssueInstantException(assertion.getID());
        }
        long clockskew = relyingPartyCtx.getProfileConfig().getSecurityConfiguration().getClockSkew();
        long currentTime = System.currentTimeMillis();
        if (issueInstant < currentTime - clockskew) {
            this.log.debug("Action {}: Issue instant has been expired", (Object)this.getId());
            throw new PastAssertionException(assertion.getID(), issueInstant);
        }
        if (issueInstant > currentTime + this.assertionLifetime + clockskew) {
            this.log.debug("Action {}: Issue instant is in the too far future", (Object)this.getId());
            throw new FutureAssertionException(assertion.getID(), issueInstant);
        }
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    public long getAssertionLifetime() {
        return this.assertionLifetime;
    }

    public synchronized void setAssertionLifetime(long lifetime) {
        if (this.isInitialized()) {
            throw new UnmodifiableComponentException("Action " + this.getId() + ": Assertion liftime can not be changed after action has been initialized");
        }
        this.assertionLifetime = lifetime;
    }

    public class NoIssueInstantException
    extends AuthenticationException {
        private static final long serialVersionUID = 6474772810183231333L;

        public NoIssueInstantException(String assertionId) {
            super("Assertion " + assertionId + " did not contain issue instant.");
        }
    }

    public class PastAssertionException
    extends AuthenticationException {
        private static final long serialVersionUID = 6474772810183231233L;

        public PastAssertionException(String assertionId, long instant) {
            super("Assertion " + assertionId + " was issued on " + new DateTime(instant).toString() + " is now considered expired.");
        }
    }

    public class FutureAssertionException
    extends AuthenticationException {
        private static final long serialVersionUID = -6474772810183213211L;

        public FutureAssertionException(String assertionId, long instant) {
            super("Assertion " + assertionId + " was issued on " + new DateTime(instant).toString() + " and is not yet valid.");
        }
    }
}

