/*
 * Decompiled with CFR 0.152.
 */
package org.glite.sts.authn;

import com.google.common.base.Function;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.webflow.Event;
import net.shibboleth.ext.spring.webflow.Events;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationException;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.idp.relyingparty.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import org.glite.sts.authn.AssertionContext;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Conditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

@Events(value={@Event(id="proceed")})
public class CheckAssertionConditions
extends AbstractAuthenticationAction {
    private final Logger log = LoggerFactory.getLogger(CheckAssertionConditions.class);
    private Function<AuthenticationRequestContext, AssertionContext> assertionCtxLookupStrategy = new ChildContextLookup(AssertionContext.class, false);
    private Function<ProfileRequestContext<?, ?>, RelyingPartyContext> rpContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class, false);
    private boolean requireConditions;
    private boolean requireAudience;

    public CheckAssertionConditions(boolean conditionsRequired, boolean audienceRequired) {
        this.requireConditions = conditionsRequired;
        this.requireAudience = audienceRequired;
    }

    @Override
    protected org.springframework.webflow.execution.Event doExecute(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestContext springRequestContext, ProfileRequestContext profileRequestContext, AuthenticationRequestContext authenticationContext) throws AuthenticationException {
        Assertion assertion = ((AssertionContext)((Object)this.assertionCtxLookupStrategy.apply((Object)authenticationContext))).getAssertion();
        RelyingPartyContext relyingPartyCtx = (RelyingPartyContext)((Object)this.rpContextLookupStrategy.apply((Object)profileRequestContext));
        Conditions conditions = assertion.getConditions();
        if (conditions == null) {
            if (this.requireConditions) {
                this.log.debug("Action {}: No conditions found in the assertion, but they are required.", (Object)this.getId());
                throw new NoConditionsInAssertionException("No conditions found in the assertion, even though they're required!");
            }
            this.log.debug("Action {}: No conditions found in the assertion, nothing left to do.", (Object)this.getId());
            return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
        }
        long currentTime = System.currentTimeMillis();
        long clockSkew = relyingPartyCtx.getProfileConfig().getSecurityConfiguration().getClockSkew();
        long notBefore = conditions.getNotBefore().getMillis();
        if (notBefore > currentTime + clockSkew) {
            this.log.debug("Action {}: This assertion cannot be consumed before {}", (Object)this.getId(), (Object)new DateTime(notBefore).toString());
            throw new NotYetValidAssertionException(notBefore);
        }
        long notOnOrAfter = conditions.getNotOnOrAfter().getMillis();
        if (notOnOrAfter < currentTime - clockSkew) {
            this.log.debug("Action {}: This assertion has been expired at {}", (Object)this.getId(), (Object)new DateTime(notOnOrAfter).toString());
            throw new ExpiredAssertionException(notOnOrAfter);
        }
        if (!this.checkAudience(conditions.getAudienceRestrictions(), relyingPartyCtx)) {
            this.log.debug("Action {}: This assertion is not targeted to the STS.", (Object)this.getId());
            throw new NotInAssertionAudienceException();
        }
        return ActionSupport.buildProceedEvent((IdentifiableComponent)this);
    }

    protected boolean checkAudience(List<AudienceRestriction> restrictions, RelyingPartyContext relyingPartyCtx) {
        if (restrictions == null) {
            this.log.debug("Action {}: No audience restrictions in the assertion", (Object)this.getId());
            return !this.requireAudience;
        }
        for (int i = 0; i < restrictions.size(); ++i) {
            AudienceRestriction restriction = restrictions.get(i);
            List audiences = restriction.getAudiences();
            if (audiences == null) continue;
            for (Audience audience : audiences) {
                this.log.debug("Action {}: Found {} in the audience", (Object)this.getId(), (Object)audience.getAudienceURI());
                if (!relyingPartyCtx.getConfiguration().getResponderEntityId().equals(audience.getAudienceURI())) continue;
                return true;
            }
        }
        return false;
    }

    public class NoConditionsInAssertionException
    extends AuthenticationException {
        private static final long serialVersionUID = 6322112342342141235L;

        public NoConditionsInAssertionException(String message) {
            super(message);
        }
    }

    public class ExpiredAssertionException
    extends AuthenticationException {
        private static final long serialVersionUID = 6432112342342141235L;

        public ExpiredAssertionException(long notOnOrAfter) {
            super("This assertion has been expired at " + new DateTime(notOnOrAfter).toString());
        }
    }

    public class NotYetValidAssertionException
    extends AuthenticationException {
        private static final long serialVersionUID = 6432112342342141233L;

        public NotYetValidAssertionException(long notBefore) {
            super("This assertion cannot be consumed before " + new DateTime(notBefore).toString());
        }
    }

    public class NotInAssertionAudienceException
    extends AuthenticationException {
        private static final long serialVersionUID = 6432112310213341233L;

        public NotInAssertionAudienceException() {
            super("This assertion is not targeted to the STS.");
        }
    }
}

