/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.session;

import com.google.common.base.Objects;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.BaseContext;

@ThreadSafe
public final class AuthenticationEvent
extends BaseContext {
    private final Principal authenticatedPrincipal;
    private final String authenticationWorkflow;
    private final long authenticationInstant;
    private long lastActivityInstant;

    public AuthenticationEvent(@Nonnull @NotEmpty String workflow, @Nonnull Principal principal) {
        this.authenticationWorkflow = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)workflow), (String)"Authentication method can not be null nor empty");
        this.authenticatedPrincipal = (Principal)Constraint.isNotNull((Object)principal, (String)"Authenticationed princpal can not be null");
        this.lastActivityInstant = this.authenticationInstant = System.currentTimeMillis();
    }

    @Nonnull
    public Principal getAuthenticatedPrincipal() {
        return this.authenticatedPrincipal;
    }

    @Nonnull
    @NotEmpty
    public String getAuthenticationWorkflow() {
        return this.authenticationWorkflow;
    }

    public long getAuthenticationInstant() {
        return this.authenticationInstant;
    }

    public long getLastActivityInstant() {
        return this.lastActivityInstant;
    }

    public void setLastActivityInstant(long instant) {
        this.lastActivityInstant = Constraint.isGreaterThan((long)0L, (long)instant, (String)"Last activity instant must be greater than 0");
    }

    public void setLastActivityInstantToNow() {
        this.lastActivityInstant = System.currentTimeMillis();
    }

    public int hashCode() {
        return this.authenticationWorkflow.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof AuthenticationEvent) {
            return Objects.equal((Object)this.getAuthenticationWorkflow(), (Object)((AuthenticationEvent)((Object)obj)).getAuthenticationWorkflow());
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("authenticationWorkflow", (Object)this.authenticationWorkflow).add("authenticatedPrincipal", (Object)this.authenticatedPrincipal).add("authenticationInstant", (Object)new DateTime(this.authenticationInstant)).add("lastActivityInstant", (Object)new DateTime(this.lastActivityInstant)).toString();
    }
}

