/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.service;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.log.EventLogger;
import net.shibboleth.idp.log.PerformanceEvent;
import net.shibboleth.idp.service.Service;
import net.shibboleth.idp.service.ServiceException;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentValidationException;
import net.shibboleth.utilities.java.support.component.ValidatableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractService
extends AbstractIdentifiableInitializableComponent
implements Service,
ValidatableComponent {
    public static final String START_PERF_EVENT_ID_SUFFIX = ".start";
    public static final String STOP_PERF_EVENT_ID_SUFFIX = ".stop";
    private final Logger log = LoggerFactory.getLogger(AbstractService.class);
    private final ImmutableSet<String> startStates = new ImmutableSet.Builder().add((Object)"starting").add((Object)"started").build();
    private final ImmutableSet<String> stopStates = new ImmutableSet.Builder().add((Object)"stopping").add((Object)"stopped").build();
    private String currentState = "new";
    private ReentrantReadWriteLock serviceLock = new ReentrantReadWriteLock(true);

    public synchronized void setId(String componentId) {
        super.setId(componentId);
    }

    @Override
    public final String getCurrentState() {
        return this.currentState;
    }

    @Override
    public final void start() throws ServiceException {
        PerformanceEvent perfEvent = new PerformanceEvent(this.getId() + START_PERF_EVENT_ID_SUFFIX);
        Lock serviceWriteLock = this.getServiceLock().writeLock();
        HashMap context = new HashMap();
        try {
            serviceWriteLock.lock();
            if (this.startStates.contains((Object)this.getCurrentState())) {
                return;
            }
            this.setCurrentState("starting");
            this.doPreStart(context);
            this.doStart(context);
            this.doPostStart(context);
            this.setCurrentState("started");
            perfEvent.stopTime(true);
        }
        catch (ServiceException e) {
            this.setCurrentState("stopped");
            perfEvent.stopTime(false);
            throw e;
        }
        finally {
            serviceWriteLock.unlock();
            EventLogger.log(perfEvent);
        }
    }

    @Override
    public final void stop() throws ServiceException {
        PerformanceEvent perfEvent = new PerformanceEvent(this.getId() + STOP_PERF_EVENT_ID_SUFFIX);
        Lock serviceWriteLock = this.getServiceLock().writeLock();
        HashMap context = new HashMap();
        try {
            serviceWriteLock.lock();
            if (this.stopStates.contains((Object)this.getCurrentState())) {
                return;
            }
            this.setCurrentState("stopping");
            this.doPreStop(context);
            this.doStop(context);
            perfEvent.stopTime(true);
        }
        catch (ServiceException e) {
            perfEvent.stopTime(false);
            throw e;
        }
        finally {
            this.doPostStop(context);
            this.setCurrentState("stopped");
            serviceWriteLock.unlock();
            EventLogger.log(perfEvent);
        }
    }

    protected final ReadWriteLock getServiceLock() {
        return this.serviceLock;
    }

    protected final void setCurrentState(String state) {
        this.currentState = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)state), (String)"State indicator may not be null or empty");
    }

    protected void doPreStart(HashMap context) throws ServiceException {
        if (this.stopStates.contains((Object)this.getCurrentState())) {
            throw new ServiceException(this.getId() + " service has been stopped, it may not be started again.");
        }
        this.log.debug("Loading configuration for service '{}'", (Object)this.getId());
    }

    protected void doStart(HashMap context) throws ServiceException {
    }

    protected void doPostStart(HashMap context) throws ServiceException {
        this.log.info("Loaded configuration for service '{}'", (Object)this.getId());
    }

    protected void doPreStop(HashMap context) throws ServiceException {
        this.log.debug("Stopping service '{}'", (Object)this.getId());
    }

    protected void doStop(HashMap context) throws ServiceException {
    }

    protected void doPostStop(HashMap context) throws ServiceException {
        this.log.info("Service '{}' has been stopped", (Object)this.getId());
    }

    public void validate() throws ComponentValidationException {
    }
}

