/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.service;

import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import net.shibboleth.idp.log.EventLogger;
import net.shibboleth.idp.log.PerformanceEvent;
import net.shibboleth.idp.service.AbstractService;
import net.shibboleth.idp.service.ReloadableService;
import net.shibboleth.idp.service.ServiceException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReloadableService
extends AbstractService
implements ReloadableService {
    private Logger log = LoggerFactory.getLogger(AbstractReloadableService.class);
    private long reloadCheckDelay = 300000L;
    private Timer reloadTaskTimer;
    private ServiceReloadTask reloadTask;
    private DateTime lastReloadInstant;
    private DateTime lastSuccessfulReleaseIntant;
    private Throwable reloadFailureCause;

    public long getReloadCheckDelay() {
        return this.reloadCheckDelay;
    }

    public synchronized void setReloadCheckDelay(long delay) {
        if (this.isInitialized()) {
            return;
        }
        this.reloadCheckDelay = delay;
    }

    public Timer getReloadTaskTimer() {
        return this.reloadTaskTimer;
    }

    public synchronized void setReloadTaskTimer(Timer timer) {
        if (this.isInitialized()) {
            return;
        }
        this.reloadTaskTimer = timer;
    }

    @Override
    public DateTime getLastReloadAttemptInstant() {
        return this.lastReloadInstant;
    }

    @Override
    public DateTime getLastSuccessfulReloadInstant() {
        return this.lastSuccessfulReleaseIntant;
    }

    @Override
    public Throwable getReloadFailureCause() {
        return this.reloadFailureCause;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.reloadCheckDelay > 0L) {
            Constraint.isNotNull((Object)this.reloadTaskTimer, (String)"Reload task timer may not be null");
            this.reloadTask = new ServiceReloadTask();
            this.reloadTaskTimer.schedule((TimerTask)this.reloadTask, this.reloadCheckDelay, this.reloadCheckDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reload() {
        DateTime now;
        PerformanceEvent perfEvent = new PerformanceEvent(this.getId() + ".reload");
        Lock serviceWriteLock = this.getServiceLock().writeLock();
        HashMap context = new HashMap();
        this.lastReloadInstant = now = new DateTime((Chronology)ISOChronology.getInstanceUTC());
        try {
            serviceWriteLock.lock();
            this.doPreReload(context);
            this.doReload(context);
            this.doPostRelaod(context);
            this.lastSuccessfulReleaseIntant = now;
            perfEvent.stopTime(true);
        }
        catch (ServiceException e) {
            this.reloadFailureCause = e;
            perfEvent.stopTime(false);
        }
        finally {
            serviceWriteLock.unlock();
            EventLogger.log(perfEvent);
        }
    }

    protected abstract boolean shouldReload();

    @Override
    protected void doPreStop(HashMap context) throws ServiceException {
        this.reloadTask.cancel();
        super.doPreStop(context);
    }

    protected void doPreReload(HashMap context) throws ServiceException {
        this.log.debug("Reloading service '{}'", (Object)this.getId());
    }

    protected void doReload(HashMap context) throws ServiceException {
    }

    protected void doPostRelaod(HashMap context) throws ServiceException {
        this.log.info("Service '{}' reloaded", (Object)this.getId());
    }

    protected class ServiceReloadTask
    extends TimerTask {
        protected ServiceReloadTask() {
        }

        @Override
        public void run() {
            if (AbstractReloadableService.this.shouldReload()) {
                AbstractReloadableService.this.reload();
            }
        }
    }
}

