/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.relyingparty;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;

public final class RelyingPartyContext
extends BaseContext {
    private final String relyingPartyId;
    private RelyingPartyConfiguration relyingPartyConfiguration;
    private ProfileConfiguration profileConfiguration;

    public RelyingPartyContext(@Nonnull @NotEmpty String rpId) {
        this.relyingPartyId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)rpId), (String)"Relying party ID can not be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getRelyingPartyId() {
        return this.relyingPartyId;
    }

    @Nullable
    public RelyingPartyConfiguration getConfiguration() {
        return this.relyingPartyConfiguration;
    }

    public void setRelyingPartyConfiguration(@Nullable RelyingPartyConfiguration config) {
        this.relyingPartyConfiguration = config;
    }

    @Nullable
    public ProfileConfiguration getProfileConfig() {
        return this.profileConfiguration;
    }

    public void setProfileConfiguration(@Nullable ProfileConfiguration config) {
        this.profileConfiguration = config;
    }
}

