/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.messaging.context.InOutOperationContext;

@ThreadSafe
public final class ProfileRequestContext<InboundMessageType, OutboundMessageType>
extends InOutOperationContext<InboundMessageType, OutboundMessageType> {
    public static final String BINDING_KEY = ProfileRequestContext.class.getName();
    public static final String ANONYMOUS_PROFILE_ID = "anonymous";
    private String profileId = "anonymous";
    private boolean passiveProfile;
    private transient HttpServletRequest httpRequest;
    private transient HttpServletResponse httpResponse;

    @Nonnull
    @NotEmpty
    public String getProfileId() {
        return this.profileId;
    }

    public void setProfileId(String id) {
        String trimmedId = StringSupport.trimOrNull((String)id);
        this.profileId = trimmedId == null ? ANONYMOUS_PROFILE_ID : id;
    }

    public boolean isPassiveProfile() {
        return this.passiveProfile;
    }

    public void setPassiveProfile(boolean isPassive) {
        this.passiveProfile = isPassive;
    }

    @Nullable
    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public void setHttpRequest(@Nullable HttpServletRequest request) {
        this.httpRequest = request;
    }

    @Nullable
    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public void setHttpResponse(@Nullable HttpServletResponse response) {
        this.httpResponse = response;
    }
}

