/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.execution.Event;

public final class ActionSupport {
    private ActionSupport() {
    }

    @Nonnull
    public static Event buildProceedEvent(@Nonnull IdentifiableComponent source) {
        return ActionSupport.buildEvent(source, "proceed");
    }

    @Nonnull
    public static Event buildEvent(@Nonnull IdentifiableComponent source, @Nonnull String eventId) {
        return ActionSupport.buildEvent(source, eventId, null);
    }

    @Nonnull
    public static Event buildEvent(@Nonnull IdentifiableComponent source, @Nonnull String eventId, @Nonnull AttributeMap eventAttributes) {
        Constraint.isNotNull((Object)source, (String)"Component may not be null");
        String trimmedEventId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)eventId), (String)("ID of event for action " + source.getId() + " may not be null"));
        if (eventAttributes == null || eventAttributes.isEmpty()) {
            return new Event((Object)source.getId(), trimmedEventId);
        }
        return new Event((Object)source.getId(), trimmedEventId, eventAttributes);
    }
}

