/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.profile;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.profile.ActionSupport;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import net.shibboleth.idp.profile.navigate.WebflowRequestContextHttpServletRequestLookup;
import net.shibboleth.idp.profile.navigate.WebflowRequestContextHttpServletResponseLookup;
import net.shibboleth.idp.profile.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.ComponentValidationException;
import net.shibboleth.utilities.java.support.component.IdentifiableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.component.ValidatableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

@ThreadSafe
public abstract class AbstractProfileAction<InboundMessageType, OutboundMessageType>
extends AbstractIdentifiableInitializableComponent
implements ValidatableComponent,
Action {
    private final Logger log = LoggerFactory.getLogger(AbstractProfileAction.class);
    private Function<RequestContext, HttpServletRequest> httpRequestLookupStrategy;
    private Function<RequestContext, HttpServletResponse> httpResponseLookupStrategy;
    private Function<RequestContext, ProfileRequestContext> profileContextLookupStrategy;

    public AbstractProfileAction() {
        this.setId(((Object)((Object)this)).getClass().getName());
        this.httpRequestLookupStrategy = new WebflowRequestContextHttpServletRequestLookup();
        this.httpResponseLookupStrategy = new WebflowRequestContextHttpServletResponseLookup();
        this.profileContextLookupStrategy = new WebflowRequestContextProfileRequestContextLookup();
    }

    public synchronized void setId(String componentId) {
        super.setId(componentId);
    }

    @Nonnull
    public Function<RequestContext, HttpServletRequest> getHttpRequestLookupStrategy() {
        return this.httpRequestLookupStrategy;
    }

    public synchronized void setHttpRequestLookupStrategy(@Nonnull Function<RequestContext, HttpServletRequest> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"HttpServletRequest lookup strategy can not be null");
    }

    @Nonnull
    public Function<RequestContext, HttpServletResponse> getHttpResponseLookupStrategy() {
        return this.httpResponseLookupStrategy;
    }

    public synchronized void setHttpResponseLookupStrategy(@Nonnull Function<RequestContext, HttpServletResponse> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.httpResponseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"HttpServletResponse lookup strategy can not be null");
    }

    @Nonnull
    public Function<RequestContext, ProfileRequestContext> getProfileContextLookupStrategy() {
        return this.profileContextLookupStrategy;
    }

    public synchronized void setProfileContextLookupStrategy(@Nonnull Function<RequestContext, ProfileRequestContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.profileContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy can not be null");
    }

    public Event execute(RequestContext springRequestContext) throws ProfileException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        HttpServletRequest httpRequest = (HttpServletRequest)this.httpRequestLookupStrategy.apply((Object)springRequestContext);
        HttpServletResponse httpResponse = (HttpServletResponse)this.httpResponseLookupStrategy.apply((Object)springRequestContext);
        ProfileRequestContext profileRequestContext = (ProfileRequestContext)((Object)this.profileContextLookupStrategy.apply((Object)springRequestContext));
        if (profileRequestContext == null) {
            this.log.error("Action {}: IdP profile request context is not available", (Object)this.getId());
            return ActionSupport.buildEvent((IdentifiableComponent)this, "InvalidProfileContext");
        }
        profileRequestContext.setHttpRequest(httpRequest);
        profileRequestContext.setHttpResponse(httpResponse);
        return this.doExecute(httpRequest, httpResponse, springRequestContext, profileRequestContext);
    }

    public void validate() throws ComponentValidationException {
    }

    protected abstract Event doExecute(HttpServletRequest var1, HttpServletResponse var2, RequestContext var3, ProfileRequestContext<InboundMessageType, OutboundMessageType> var4) throws ProfileException;
}

