/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.log;

import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.idp.log.BaseEvent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

@NotThreadSafe
public class PerformanceEvent
extends BaseEvent {
    public static final String EVENT_TYPE = "performance";
    private static final String FIELD_SEPERATOR = "|";
    private String operation;
    private boolean successfulOperation;
    private long startTime;
    private long stopTime;
    private long elapsedTime;

    public PerformanceEvent(String operationId) {
        this.operation = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)operationId), (String)"Operation identifier may not be null or empty");
        this.successfulOperation = false;
        this.startTime = -1L;
        this.stopTime = -1L;
        this.elapsedTime = -1L;
    }

    @Override
    public String getType() {
        return EVENT_TYPE;
    }

    public String getOperation() {
        return this.operation;
    }

    public boolean isOperationSuccessful() {
        return this.successfulOperation;
    }

    public void startTime() {
        if (this.startTime != -1L) {
            throw new IllegalStateException("Event timer has already been started");
        }
        this.startTime = System.currentTimeMillis();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void stopTime(boolean wasSuccess) {
        if (this.startTime == -1L) {
            throw new IllegalStateException("Event timer has not been started");
        }
        this.stopTime = System.currentTimeMillis();
        this.elapsedTime = this.stopTime - this.startTime;
        this.successfulOperation = wasSuccess;
    }

    public long getStopTime() {
        return this.stopTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String toString() {
        StringBuilder entry = new StringBuilder();
        entry.append(this.getOperation()).append(FIELD_SEPERATOR);
        entry.append(this.getStartTime()).append(FIELD_SEPERATOR);
        entry.append(this.getStopTime()).append(FIELD_SEPERATOR);
        entry.append(this.getElapsedTime()).append(FIELD_SEPERATOR);
        if (this.isOperationSuccessful()) {
            entry.append(1).append(FIELD_SEPERATOR);
        } else {
            entry.append(0).append(FIELD_SEPERATOR);
        }
        if (this.getMessage() != null) {
            entry.append(this.getMessage());
        }
        return entry.toString();
    }
}

