/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.Objects;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class AuthenticationWorkflowDescriptor {
    private final String workflowId;
    private boolean supportsPassive;
    private boolean supportsForcedAuthentication;
    private long lifetime;
    private long timeout;

    public AuthenticationWorkflowDescriptor(@Nonnull @NotEmpty String id) {
        this.workflowId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Workflow ID can not be null or empty");
    }

    @Nonnull
    @NotEmpty
    public String getWorkflowId() {
        return this.workflowId;
    }

    public boolean isPassiveAuthenticationSupported() {
        return this.supportsPassive;
    }

    public void setPassiveAuthenticationSupported(boolean isSupported) {
        this.supportsPassive = isSupported;
    }

    public boolean isForcedAuthenticationSupported() {
        return this.supportsForcedAuthentication;
    }

    public void setForcedAuthenticationSupported(boolean isSupported) {
        this.supportsForcedAuthentication = isSupported;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(long workflowLifetime) {
        this.lifetime = Constraint.isGreaterThanOrEqual((long)0L, (long)workflowLifetime, (String)"Lifetime must be greater than or equal to 0");
    }

    public long getInactivityTimeout() {
        return this.timeout;
    }

    public void setInactivityTimeout(long inactivityTimeout) {
        this.timeout = Constraint.isGreaterThanOrEqual((long)0L, (long)inactivityTimeout, (String)"Inactivity timeout must be greater than, or equal to, 0");
    }

    public int hashCode() {
        return this.workflowId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof AuthenticationWorkflowDescriptor) {
            return this.workflowId.equals(((AuthenticationWorkflowDescriptor)obj).getWorkflowId());
        }
        return false;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("workflowId", (Object)this.workflowId).add("supportsPassive", this.supportsPassive).add("supportsForcedAuthentication", this.supportsForcedAuthentication).add("lifetime", this.lifetime).add("inactivityTimeout", this.timeout).toString();
    }
}

