/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.AuthenticationWorkflowDescriptor;
import net.shibboleth.idp.session.AuthenticationEvent;
import net.shibboleth.idp.session.IdPSession;
import net.shibboleth.utilities.java.support.annotation.constraint.Live;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NullableElements;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.DateTime;
import org.opensaml.messaging.context.BaseContext;

@ThreadSafe
public final class AuthenticationRequestContext
extends BaseContext {
    private final long initiationInstant = System.currentTimeMillis();
    private boolean forcingAuthentication;
    private final Optional<IdPSession> activeSession;
    private final ImmutableMap<String, AuthenticationWorkflowDescriptor> activeWorkflows;
    private final ImmutableMap<String, AuthenticationWorkflowDescriptor> availableWorkflows;
    private Map<String, AuthenticationWorkflowDescriptor> potentialWorkflows;
    private Map<String, AuthenticationWorkflowDescriptor> requestedWorkflows;
    private Optional<AuthenticationWorkflowDescriptor> attemptedWorkflow;
    private Optional<Principal> authenticatedPrincipal;
    private long completionInstant;

    public AuthenticationRequestContext(@Nullable IdPSession session, @Nullable @NullableElements Collection<AuthenticationWorkflowDescriptor> availableFlows) {
        this.activeSession = Optional.fromNullable((Object)((Object)session));
        ImmutableMap.Builder flowsBuilder = new ImmutableMap.Builder();
        if (availableFlows != null) {
            for (AuthenticationWorkflowDescriptor descriptor : availableFlows) {
                if (descriptor == null) continue;
                flowsBuilder.put((Object)descriptor.getWorkflowId(), (Object)descriptor);
            }
        }
        this.availableWorkflows = flowsBuilder.build();
        this.potentialWorkflows = new HashMap<String, AuthenticationWorkflowDescriptor>((Map<String, AuthenticationWorkflowDescriptor>)this.availableWorkflows);
        this.activeWorkflows = this.activeSession.isPresent() ? this.getActiveWorkflowsBySession((Map<String, AuthenticationWorkflowDescriptor>)this.availableWorkflows, session) : new ImmutableMap.Builder().build();
        this.requestedWorkflows = Collections.emptyMap();
        this.attemptedWorkflow = Optional.absent();
        this.authenticatedPrincipal = Optional.absent();
    }

    public long getInitiationInstant() {
        return this.initiationInstant;
    }

    public Optional<IdPSession> getActiveSession() {
        return this.activeSession;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, AuthenticationWorkflowDescriptor> getActiveWorkflows() {
        return this.activeWorkflows;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, AuthenticationWorkflowDescriptor> getAvailableWorkflows() {
        return this.availableWorkflows;
    }

    @Nonnull
    @Live
    public Map<String, AuthenticationWorkflowDescriptor> getPotentialWorkflows() {
        return this.potentialWorkflows;
    }

    public boolean isForcingAuthentication() {
        return this.forcingAuthentication;
    }

    @Nonnull
    public AuthenticationRequestContext setForcingAuthentication(boolean force) {
        this.forcingAuthentication = force;
        return this;
    }

    @Nonnull
    @NonnullElements
    @Unmodifiable
    public Map<String, AuthenticationWorkflowDescriptor> getRequestedWorkflows() {
        return this.requestedWorkflows;
    }

    @Nonnull
    public AuthenticationRequestContext setRequestedWorkflows(@Nullable @NullableElements List<AuthenticationWorkflowDescriptor> workflows) {
        if (workflows == null || workflows.isEmpty()) {
            this.requestedWorkflows = Collections.emptyMap();
            return this;
        }
        ImmutableMap.Builder flowsBuilder = new ImmutableMap.Builder();
        for (AuthenticationWorkflowDescriptor descriptor : workflows) {
            if (descriptor == null) continue;
            flowsBuilder.put((Object)descriptor.getWorkflowId(), (Object)descriptor);
        }
        this.requestedWorkflows = flowsBuilder.build();
        return this;
    }

    @Nonnull
    public Optional<AuthenticationWorkflowDescriptor> getAttemptedWorkflow() {
        return this.attemptedWorkflow;
    }

    @Nonnull
    public AuthenticationRequestContext setAttemptedWorkflow(@Nonnull AuthenticationWorkflowDescriptor workflow) {
        Constraint.isNotNull((Object)workflow, (String)"Authentication workflow descriptor can not be null");
        this.attemptedWorkflow = Optional.of((Object)workflow);
        return this;
    }

    @Nonnull
    public Optional<Principal> getAuthenticatedPrincipal() {
        return this.authenticatedPrincipal;
    }

    @Nonnull
    public AuthenticationRequestContext setAuthenticatedPrincipal(@Nonnull Principal principal) {
        Constraint.isNotNull((Object)principal, (String)"Principal can not be null");
        this.authenticatedPrincipal = Optional.of((Object)principal);
        return this;
    }

    public long getCompletionInstant() {
        return this.completionInstant;
    }

    @Nonnull
    public AuthenticationRequestContext setCompletionInstant() {
        this.completionInstant = System.currentTimeMillis();
        return this;
    }

    @Nonnull
    public AuthenticationEvent buildAuthenticationEvent() {
        if (!this.attemptedWorkflow.isPresent()) {
            throw new IllegalStateException("No authentication workflow has been attempted");
        }
        if (!this.authenticatedPrincipal.isPresent()) {
            throw new IllegalStateException("No principal has been authenticated");
        }
        return new AuthenticationEvent(((AuthenticationWorkflowDescriptor)this.attemptedWorkflow.get()).getWorkflowId(), (Principal)this.authenticatedPrincipal.get());
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("initiationInstant", (Object)new DateTime(this.initiationInstant)).add("activeSession", (Object)(this.activeSession.isPresent() ? ((IdPSession)((Object)this.activeSession.get())).getId() : "null")).add("activeWorkflows", (Object)this.activeWorkflows.keySet()).add("availableWorkflows", (Object)this.availableWorkflows.keySet()).add("forcingAuthentication", this.forcingAuthentication).add("requestedWorkflows", this.requestedWorkflows).add("attemptedWorkflow", this.attemptedWorkflow).add("authenticatedPrincipal", this.authenticatedPrincipal).add("completionInstant", (Object)new DateTime(this.completionInstant)).toString();
    }

    protected ImmutableMap<String, AuthenticationWorkflowDescriptor> getActiveWorkflowsBySession(@Nonnull @NonnullElements @Unmodifiable Map<String, AuthenticationWorkflowDescriptor> availableFlows, @Nonnull IdPSession session) {
        ImmutableMap.Builder activeFlowsBuilder = new ImmutableMap.Builder();
        for (AuthenticationEvent event : session.getAuthenticateEvents()) {
            AuthenticationWorkflowDescriptor descriptor = availableFlows.get(event.getAuthenticationWorkflow());
            if (descriptor == null) continue;
            activeFlowsBuilder.put((Object)descriptor.getWorkflowId(), (Object)descriptor);
        }
        return activeFlowsBuilder.build();
    }
}

