/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.authn.AuthenticationException;
import net.shibboleth.idp.authn.AuthenticationRequestContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.ProfileException;
import net.shibboleth.idp.profile.ProfileRequestContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractAuthenticationAction
extends AbstractProfileAction {
    private Function<ProfileRequestContext, AuthenticationRequestContext> authnCtxLookupStrategy = new ChildContextLookup(AuthenticationRequestContext.class, false);

    protected final Event doExecute(@Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse, @Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) throws ProfileException {
        AuthenticationRequestContext authenticationContext = (AuthenticationRequestContext)((Object)this.authnCtxLookupStrategy.apply((Object)profileRequestContext));
        if (authenticationContext == null) {
            throw new NoAuthenticationContextException();
        }
        return this.doExecute(httpRequest, httpResponse, springRequestContext, profileRequestContext, authenticationContext);
    }

    protected abstract Event doExecute(@Nonnull HttpServletRequest var1, @Nonnull HttpServletResponse var2, @Nonnull RequestContext var3, @Nonnull ProfileRequestContext var4, @Nonnull AuthenticationRequestContext var5) throws AuthenticationException;

    public static final class NoAuthenticationContextException
    extends ProfileException {
        private static final long serialVersionUID = -3111452312531745371L;
    }
}

