/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.security.credential.Credential;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletResponseAdapter
implements HTTPOutTransport {
    private HttpServletResponse httpServletResponse;
    private final Logger log = LoggerFactory.getLogger(HttpServletResponseAdapter.class);
    private boolean peerAuthenticated;
    private boolean secure;

    public HttpServletResponseAdapter(HttpServletResponse response, boolean isSecure) {
        this.httpServletResponse = response;
        this.secure = isSecure;
    }

    @Override
    public Object getAttribute(String name) {
        return null;
    }

    @Override
    public String getCharacterEncoding() {
        return this.httpServletResponse.getCharacterEncoding();
    }

    @Override
    public String getHeaderValue(String name) {
        return null;
    }

    @Override
    public String getHTTPMethod() {
        return null;
    }

    @Override
    public Credential getLocalCredential() {
        return null;
    }

    @Override
    public OutputStream getOutgoingStream() {
        try {
            return this.httpServletResponse.getOutputStream();
        }
        catch (IOException e) {
            this.log.error("Unable to recover input stream from adapted HttpServletResponse", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getParameterValue(String name) {
        return null;
    }

    @Override
    public List<String> getParameterValues(String name) {
        return null;
    }

    @Override
    public Credential getPeerCredential() {
        return null;
    }

    @Override
    public int getStatusCode() {
        return -1;
    }

    @Override
    public HTTPTransport.HTTP_VERSION getVersion() {
        return null;
    }

    public HttpServletResponse getWrappedResponse() {
        return this.httpServletResponse;
    }

    @Override
    public boolean isAuthenticated() {
        return this.peerAuthenticated;
    }

    @Override
    public boolean isConfidential() {
        return this.secure;
    }

    @Override
    public void sendRedirect(String location) {
        try {
            this.httpServletResponse.sendRedirect(location);
        }
        catch (IOException e) {
            this.log.error("Unable to send redirect message", (Throwable)e);
        }
    }

    @Override
    public void setAttribute(String name, Object value) {
    }

    @Override
    public void setAuthenticated(boolean isAuthenticated) {
        this.peerAuthenticated = isAuthenticated;
    }

    @Override
    public void setCharacterEncoding(String encoding) {
        this.httpServletResponse.setCharacterEncoding(encoding);
    }

    @Override
    public void setConfidential(boolean isConfidential) {
    }

    @Override
    public void setHeader(String name, String value) {
        if (name == null) {
            return;
        }
        if (name.equalsIgnoreCase("Content-Type")) {
            this.httpServletResponse.setContentType(value);
        } else if (name.equalsIgnoreCase("Content-Length")) {
            this.httpServletResponse.setContentLength(Integer.parseInt(value));
        }
        this.httpServletResponse.setHeader(name, value);
    }

    @Override
    public void addParameter(String name, String value) {
    }

    @Override
    public void setStatusCode(int code) {
        this.httpServletResponse.setStatus(code);
    }

    @Override
    public void setVersion(HTTPTransport.HTTP_VERSION version) {
    }

    @Override
    public boolean isIntegrityProtected() {
        return this.secure;
    }

    @Override
    public void setIntegrityProtected(boolean isIntegrityProtected) {
    }
}

