/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.message.encoder;

import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncoder;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BaseMessageEncoder
implements MessageEncoder {
    private Logger protocolMessageLog = LoggerFactory.getLogger((String)"PROTOCOL_MESSAGE");
    private final Logger log = LoggerFactory.getLogger(BaseMessageEncoder.class);

    @Override
    public void encode(MessageContext messageContext) throws MessageEncodingException {
        this.log.debug("Beginning encode message to outbound transport of type: {}", (Object)messageContext.getOutboundMessageTransport().getClass().getName());
        this.doEncode(messageContext);
        this.logEncodedMessage(messageContext);
        this.log.debug("Successfully encoded message.");
    }

    protected void logEncodedMessage(MessageContext messageContext) {
        if (this.protocolMessageLog.isDebugEnabled() && messageContext.getOutboundMessage() != null) {
            if (messageContext.getOutboundMessage().getDOM() == null) {
                try {
                    this.marshallMessage(messageContext.getOutboundMessage());
                }
                catch (MessageEncodingException e) {
                    this.log.error("Unable to marshall message for logging purposes: " + e.getMessage());
                    return;
                }
            }
            this.protocolMessageLog.debug("\n" + SerializeSupport.prettyPrintXML((Node)messageContext.getOutboundMessage().getDOM()));
        }
    }

    protected abstract void doEncode(MessageContext var1) throws MessageEncodingException;

    protected Element marshallMessage(XMLObject message) throws MessageEncodingException {
        this.log.debug("Marshalling message");
        try {
            Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(message);
            if (marshaller == null) {
                this.log.error("Unable to marshall message, no marshaller registered for message object: " + message.getElementQName());
                throw new MessageEncodingException("Unable to marshall message, no marshaller registered for message object: " + message.getElementQName());
            }
            Element messageElem = marshaller.marshall(message);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Marshalled message into DOM:\n{}", (Object)SerializeSupport.nodeToString((Node)messageElem));
            }
            return messageElem;
        }
        catch (MarshallingException e) {
            this.log.error("Encountered error marshalling message to its DOM representation", (Throwable)e);
            throw new MessageEncodingException("Encountered error marshalling message into its DOM representation", (Exception)((Object)e));
        }
    }
}

