/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import net.shibboleth.utilities.java.support.collection.LazyList;
import org.opensaml.core.xml.XMLObject;

public class XMLObjectChildrenList<ElementType extends XMLObject>
extends AbstractList<ElementType> {
    private XMLObject parent;
    private List<ElementType> elements;

    public XMLObjectChildrenList(XMLObject newParent) throws NullPointerException {
        if (newParent == null) {
            throw new NullPointerException("Parent may not be null");
        }
        this.parent = newParent;
        this.elements = new LazyList();
    }

    public XMLObjectChildrenList(XMLObject newParent, Collection<ElementType> newElements) throws NullPointerException {
        if (newParent == null) {
            throw new NullPointerException("Parent may not be null");
        }
        this.parent = newParent;
        this.elements = new LazyList();
        this.addAll(newElements);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public boolean contains(ElementType element) {
        return this.elements.contains(element);
    }

    @Override
    public ElementType get(int index) {
        return (ElementType)((XMLObject)this.elements.get(index));
    }

    @Override
    public ElementType set(int index, ElementType element) throws IllegalArgumentException {
        if (element == null) {
            return null;
        }
        this.setParent(element);
        XMLObject removedElement = (XMLObject)this.elements.set(index, element);
        if (removedElement != null) {
            removedElement.setParent(null);
            this.parent.getIDIndex().deregisterIDMappings(removedElement.getIDIndex());
        }
        this.parent.getIDIndex().registerIDMappings(element.getIDIndex());
        ++this.modCount;
        return (ElementType)removedElement;
    }

    @Override
    public void add(int index, ElementType element) throws IllegalArgumentException {
        if (element == null || this.elements.contains(element)) {
            return;
        }
        this.setParent(element);
        this.parent.getIDIndex().registerIDMappings(element.getIDIndex());
        ++this.modCount;
        this.elements.add(index, element);
    }

    @Override
    public ElementType remove(int index) {
        XMLObject element = (XMLObject)this.elements.remove(index);
        if (element != null) {
            element.releaseParentDOM(true);
            element.setParent(null);
            this.parent.getIDIndex().deregisterIDMappings(element.getIDIndex());
        }
        ++this.modCount;
        return (ElementType)element;
    }

    @Override
    public boolean remove(ElementType element) {
        boolean elementRemoved = false;
        elementRemoved = this.elements.remove(element);
        if (elementRemoved && element != null) {
            element.releaseParentDOM(true);
            element.setParent(null);
            this.parent.getIDIndex().deregisterIDMappings(element.getIDIndex());
        }
        return elementRemoved;
    }

    protected void setParent(ElementType element) throws IllegalArgumentException {
        XMLObject elemParent = element.getParent();
        if (elemParent != null && elemParent != this.parent) {
            throw new IllegalArgumentException(element.getElementQName() + " is already the child of another XMLObject and may not be inserted in to this list");
        }
        element.setParent(this.parent);
        element.releaseParentDOM(true);
    }
}

