/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.util;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import net.shibboleth.utilities.java.support.collection.LazyMap;
import org.opensaml.core.xml.XMLObject;

@NotThreadSafe
public class IDIndex {
    private XMLObject owner;
    private Map<String, XMLObject> idMappings;

    public IDIndex(XMLObject newOwner) throws NullPointerException {
        if (newOwner == null) {
            throw new NullPointerException("Attribute owner XMLObject may not be null");
        }
        this.owner = newOwner;
        this.idMappings = new LazyMap();
    }

    public void registerIDMapping(String id, XMLObject referent) {
        if (id == null) {
            return;
        }
        this.idMappings.put(id, referent);
        if (this.owner.hasParent()) {
            this.owner.getParent().getIDIndex().registerIDMapping(id, referent);
        }
    }

    public void registerIDMappings(IDIndex idIndex) {
        if (idIndex == null || idIndex.isEmpty()) {
            return;
        }
        this.idMappings.putAll(idIndex.getIDMappings());
        if (this.owner.hasParent()) {
            this.owner.getParent().getIDIndex().registerIDMappings(idIndex);
        }
    }

    public void deregisterIDMapping(String id) {
        if (id == null) {
            return;
        }
        this.idMappings.remove(id);
        if (this.owner.hasParent()) {
            this.owner.getParent().getIDIndex().deregisterIDMapping(id);
        }
    }

    public void deregisterIDMappings(IDIndex idIndex) {
        if (idIndex == null || idIndex.isEmpty()) {
            return;
        }
        for (String id : idIndex.getIDs()) {
            this.idMappings.remove(id);
        }
        if (this.owner.hasParent()) {
            this.owner.getParent().getIDIndex().deregisterIDMappings(idIndex);
        }
    }

    public XMLObject lookup(String id) {
        return this.idMappings.get(id);
    }

    public boolean isEmpty() {
        return this.idMappings.isEmpty();
    }

    public Set<String> getIDs() {
        return Collections.unmodifiableSet(this.idMappings.keySet());
    }

    protected Map<String, XMLObject> getIDMappings() {
        return Collections.unmodifiableMap(this.idMappings);
    }
}

