/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml.io;

import com.google.common.base.Objects;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.xml.DomTypeSupport;
import net.shibboleth.utilities.java.support.xml.QNameSupport;
import net.shibboleth.utilities.java.support.xml.XmlConstants;
import org.opensaml.core.xml.AttributeExtensibleXMLObject;
import org.opensaml.core.xml.Namespace;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractXMLObjectUnmarshaller
implements Unmarshaller {
    private final Logger log = LoggerFactory.getLogger(AbstractXMLObjectUnmarshaller.class);
    private QName targetQName;
    private XMLObjectBuilderFactory xmlObjectBuilderFactory;
    private UnmarshallerFactory unmarshallerFactory;

    protected AbstractXMLObjectUnmarshaller() {
        this.xmlObjectBuilderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
    }

    protected AbstractXMLObjectUnmarshaller(String targetNamespaceURI, String targetLocalName) {
        this.targetQName = QNameSupport.constructQName((String)targetNamespaceURI, (String)targetLocalName, null);
        this.xmlObjectBuilderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        this.unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
    }

    @Override
    public XMLObject unmarshall(Element domElement) throws UnmarshallingException {
        this.log.trace("Starting to unmarshall DOM element {}", (Object)QNameSupport.getNodeQName((Node)domElement));
        this.checkElementIsTarget(domElement);
        XMLObject xmlObject = this.buildXMLObject(domElement);
        this.log.trace("Unmarshalling attributes of DOM Element {}", (Object)QNameSupport.getNodeQName((Node)domElement));
        NamedNodeMap attributes = domElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute.getNodeType() != 2) continue;
            this.unmarshallAttribute(xmlObject, (Attr)attribute);
        }
        this.log.trace("Unmarshalling other child nodes of DOM Element {}", (Object)QNameSupport.getNodeQName((Node)domElement));
        NodeList childNodes = domElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 2) {
                this.unmarshallAttribute(xmlObject, (Attr)childNode);
                continue;
            }
            if (childNode.getNodeType() == 1) {
                this.unmarshallChildElement(xmlObject, (Element)childNode);
                continue;
            }
            if (childNode.getNodeType() != 3) continue;
            this.unmarshallTextContent(xmlObject, (Text)childNode);
        }
        xmlObject.setDOM(domElement);
        return xmlObject;
    }

    protected void checkElementIsTarget(Element domElement) throws UnmarshallingException {
        QName elementName = QNameSupport.getNodeQName((Node)domElement);
        if (this.targetQName == null) {
            this.log.trace("Targeted QName checking is not available for this unmarshaller, DOM Element {} was not verified", (Object)elementName);
            return;
        }
        this.log.trace("Checking that {} meets target criteria.", (Object)elementName);
        QName type = DomTypeSupport.getXSIType((Element)domElement);
        if (type != null && type.equals(this.targetQName)) {
            this.log.trace("{} schema type matches target.", (Object)elementName);
            return;
        }
        if (elementName.equals(this.targetQName)) {
            this.log.trace("{} element name matches target.", (Object)elementName);
            return;
        }
        String errorMsg = "This unmarshaller only operates on " + this.targetQName + " elements not " + elementName;
        this.log.error(errorMsg);
        throw new UnmarshallingException(errorMsg);
    }

    protected XMLObject buildXMLObject(Element domElement) throws UnmarshallingException {
        this.log.trace("Building XMLObject for {}", (Object)QNameSupport.getNodeQName((Node)domElement));
        XMLObjectBuilder xmlObjectBuilder = this.xmlObjectBuilderFactory.getBuilder(domElement);
        if (xmlObjectBuilder == null) {
            xmlObjectBuilder = this.xmlObjectBuilderFactory.getBuilder(XMLObjectProviderRegistrySupport.getDefaultProviderQName());
            if (xmlObjectBuilder == null) {
                String errorMsg = "Unable to located builder for " + QNameSupport.getNodeQName((Node)domElement);
                this.log.error(errorMsg);
                throw new UnmarshallingException(errorMsg);
            }
            this.log.trace("No builder was registered for {} but the default builder {} was available, using it.", (Object)QNameSupport.getNodeQName((Node)domElement), (Object)xmlObjectBuilder.getClass().getName());
        }
        return xmlObjectBuilder.buildObject(domElement);
    }

    protected void unmarshallAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
        QName attribName = QNameSupport.getNodeQName((Node)attribute);
        this.log.trace("Pre-processing attribute {}", (Object)attribName);
        String attributeNamespace = StringSupport.trimOrNull((String)attribute.getNamespaceURI());
        if (Objects.equal((Object)attributeNamespace, (Object)"http://www.w3.org/2000/xmlns/")) {
            this.unmarshallNamespaceAttribute(xmlObject, attribute);
        } else if (Objects.equal((Object)attributeNamespace, (Object)"http://www.w3.org/2001/XMLSchema-instance")) {
            this.unmarshallSchemaInstanceAttributes(xmlObject, attribute);
        } else {
            this.log.trace("Attribute {} is neither a schema type nor namespace, calling processAttribute()", (Object)QNameSupport.getNodeQName((Node)attribute));
            String attributeNSURI = attribute.getNamespaceURI();
            if (attributeNSURI != null) {
                String attributeNSPrefix = attribute.lookupPrefix(attributeNSURI);
                if (attributeNSPrefix == null && "http://www.w3.org/XML/1998/namespace".equals(attributeNSURI)) {
                    attributeNSPrefix = "xml";
                }
                xmlObject.getNamespaceManager().registerAttributeName(attribName);
            }
            this.checkIDAttribute(attribute);
            this.processAttribute(xmlObject, attribute);
        }
    }

    protected void unmarshallNamespaceAttribute(XMLObject xmlObject, Attr attribute) {
        this.log.trace("{} is a namespace declaration, adding it to the list of namespaces on the XMLObject", (Object)QNameSupport.getNodeQName((Node)attribute));
        Namespace namespace = Objects.equal((Object)attribute.getLocalName(), (Object)"xmlns") ? new Namespace(attribute.getValue(), null) : new Namespace(attribute.getValue(), attribute.getLocalName());
        xmlObject.getNamespaceManager().registerNamespaceDeclaration(namespace);
    }

    protected void unmarshallSchemaInstanceAttributes(XMLObject xmlObject, Attr attribute) {
        QName attribName = QNameSupport.getNodeQName((Node)attribute);
        if (XmlConstants.XSI_TYPE_ATTRIB_NAME.equals(attribName)) {
            this.log.trace("Saw XMLObject {} with an xsi:type of: {}", (Object)xmlObject.getElementQName(), (Object)attribute.getValue());
        } else if (XmlConstants.XSI_SCHEMA_LOCATION_ATTRIB_NAME.equals(attribName)) {
            this.log.trace("Saw XMLObject {} with an xsi:schemaLocation of: {}", (Object)xmlObject.getElementQName(), (Object)attribute.getValue());
            xmlObject.setSchemaLocation(attribute.getValue());
        } else if (XmlConstants.XSI_NO_NAMESPACE_SCHEMA_LOCATION_ATTRIB_NAME.equals(attribName)) {
            this.log.trace("Saw XMLObject {} with an xsi:noNamespaceSchemaLocation of: {}", (Object)xmlObject.getElementQName(), (Object)attribute.getValue());
            xmlObject.setNoNamespaceSchemaLocation(attribute.getValue());
        } else if (XmlConstants.XSI_NIL_ATTRIB_NAME.equals(attribName)) {
            this.log.trace("Saw XMLObject {} with an xsi:nil of: {}", (Object)xmlObject.getElementQName(), (Object)attribute.getValue());
            xmlObject.setNil(XSBooleanValue.valueOf(attribute.getValue()));
        }
    }

    protected void checkIDAttribute(Attr attribute) {
        QName attribName = QNameSupport.getNodeQName((Node)attribute);
        if (XMLObjectProviderRegistrySupport.isIDAttribute(attribName) && !attribute.isId()) {
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        }
    }

    protected void unmarshallChildElement(XMLObject xmlObject, Element childElement) throws UnmarshallingException {
        this.log.trace("Unmarshalling child elements of XMLObject {}", (Object)xmlObject.getElementQName());
        Unmarshaller unmarshaller = this.unmarshallerFactory.getUnmarshaller(childElement);
        if (unmarshaller == null) {
            unmarshaller = this.unmarshallerFactory.getUnmarshaller(XMLObjectProviderRegistrySupport.getDefaultProviderQName());
            if (unmarshaller == null) {
                String errorMsg = "No unmarshaller available for " + QNameSupport.getNodeQName((Node)childElement) + ", child of " + xmlObject.getElementQName();
                this.log.error(errorMsg);
                throw new UnmarshallingException(errorMsg);
            }
            this.log.trace("No unmarshaller was registered for {}, child of {}. Using default unmarshaller.", (Object)QNameSupport.getNodeQName((Node)childElement), (Object)xmlObject.getElementQName());
        }
        this.log.trace("Unmarshalling child element {}with unmarshaller {}", (Object)QNameSupport.getNodeQName((Node)childElement), (Object)unmarshaller.getClass().getName());
        this.processChildElement(xmlObject, unmarshaller.unmarshall(childElement));
    }

    protected void unmarshallTextContent(XMLObject xmlObject, Text content) throws UnmarshallingException {
        String textContent = StringSupport.trimOrNull((String)content.getWholeText());
        if (textContent != null) {
            this.processElementContent(xmlObject, textContent);
        }
    }

    protected void processChildElement(XMLObject parentXMLObject, XMLObject childXMLObject) throws UnmarshallingException {
        this.log.debug("Ignorning unknown child element {}", (Object)childXMLObject.getElementQName());
    }

    protected void processAttribute(XMLObject xmlObject, Attr attribute) throws UnmarshallingException {
        this.log.debug("Ignorning unknown attribute {}", (Object)QNameSupport.getNodeQName((Node)attribute));
    }

    protected void processElementContent(XMLObject xmlObject, String elementContent) {
        this.log.debug("Ignorning unknown element content {}", (Object)elementContent);
    }

    protected void processUnknownAttribute(AttributeExtensibleXMLObject xmlObject, Attr attribute) {
        XMLObjectSupport.unmarshallToAttributeMap(xmlObject.getUnknownAttributes(), attribute);
    }
}

