/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.xml;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.collection.LazyMap;
import net.shibboleth.utilities.java.support.collection.LazySet;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.core.xml.Namespace;
import org.opensaml.core.xml.XMLObject;

public class NamespaceManager {
    public static final String DEFAULT_NS_TOKEN = "#default";
    private static final Namespace XML_NAMESPACE = new Namespace("http://www.w3.org/XML/1998/namespace", "xml");
    private static final Namespace XSI_NAMESPACE = new Namespace("http://www.w3.org/2001/XMLSchema-instance", "xsi");
    private XMLObject owner;
    private Namespace elementName;
    private Namespace elementType;
    private Set<Namespace> decls;
    private Set<Namespace> attrNames;
    private Map<String, Namespace> attrValues;
    private Namespace contentValue;

    public NamespaceManager(XMLObject owningObject) {
        this.owner = owningObject;
        this.decls = new LazySet();
        this.attrNames = new LazySet();
        this.attrValues = new LazyMap();
    }

    public static String generateAttributeID(QName name) {
        return name.toString();
    }

    public XMLObject getOwner() {
        return this.owner;
    }

    public Set<Namespace> getNamespaces() {
        Set<Namespace> namespaces = this.mergeNamespaceCollections(this.decls, this.attrNames, this.attrValues.values());
        this.addNamespace(namespaces, this.getElementNameNamespace());
        this.addNamespace(namespaces, this.getElementTypeNamespace());
        this.addNamespace(namespaces, this.contentValue);
        return Collections.unmodifiableSet(namespaces);
    }

    public void registerNamespaceDeclaration(Namespace namespace) {
        this.addNamespace(this.decls, namespace);
    }

    public void deregisterNamespaceDeclaration(Namespace namespace) {
        this.removeNamespace(this.decls, namespace);
    }

    public Set<Namespace> getNamespaceDeclarations() {
        return Collections.unmodifiableSet(this.decls);
    }

    public void registerAttributeName(QName attributeName) {
        if (this.checkQName(attributeName)) {
            this.addNamespace(this.attrNames, this.buildNamespace(attributeName));
        }
    }

    public void deregisterAttributeName(QName attributeName) {
        if (this.checkQName(attributeName)) {
            this.removeNamespace(this.attrNames, this.buildNamespace(attributeName));
        }
    }

    public void registerAttributeValue(String attributeID, QName attributeValue) {
        if (this.checkQName(attributeValue)) {
            this.attrValues.put(attributeID, this.buildNamespace(attributeValue));
        }
    }

    public void deregisterAttributeValue(String attributeID) {
        this.attrValues.remove(attributeID);
    }

    public void registerContentValue(QName content) {
        if (this.checkQName(content)) {
            this.contentValue = this.buildNamespace(content);
        }
    }

    public void deregisterContentValue() {
        this.contentValue = null;
    }

    public Set<String> getNonVisibleNamespacePrefixes() {
        LazySet prefixes = new LazySet();
        this.addPrefixes((Set<String>)prefixes, this.getNonVisibleNamespaces());
        return prefixes;
    }

    public Set<Namespace> getNonVisibleNamespaces() {
        LazySet nonVisibleCandidates = new LazySet();
        List<XMLObject> children = this.getOwner().getOrderedChildren();
        if (children != null) {
            for (XMLObject child : this.getOwner().getOrderedChildren()) {
                Set<Namespace> childNonVisibleNamespaces;
                if (child == null || (childNonVisibleNamespaces = child.getNamespaceManager().getNonVisibleNamespaces()) == null || childNonVisibleNamespaces.isEmpty()) continue;
                nonVisibleCandidates.addAll(childNonVisibleNamespaces);
            }
        }
        nonVisibleCandidates.addAll(this.getNonVisibleNamespaceCandidates());
        nonVisibleCandidates.removeAll(this.getVisibleNamespaces());
        nonVisibleCandidates.remove((Object)XML_NAMESPACE);
        return nonVisibleCandidates;
    }

    public Set<Namespace> getAllNamespacesInSubtreeScope() {
        LazySet namespaces = new LazySet();
        List<XMLObject> children = this.getOwner().getOrderedChildren();
        if (children != null) {
            for (XMLObject child : this.getOwner().getOrderedChildren()) {
                Set<Namespace> childNamespaces;
                if (child == null || (childNamespaces = child.getNamespaceManager().getAllNamespacesInSubtreeScope()) == null || childNamespaces.isEmpty()) continue;
                namespaces.addAll(childNamespaces);
            }
        }
        for (Namespace myNS : this.getNamespaces()) {
            namespaces.add((Object)myNS);
        }
        return namespaces;
    }

    public void registerElementName(QName name) {
        if (this.checkQName(name)) {
            this.elementName = this.buildNamespace(name);
        }
    }

    public void registerElementType(QName type) {
        if (type != null) {
            if (this.checkQName(type)) {
                this.elementType = this.buildNamespace(type);
            }
        } else {
            this.elementType = null;
        }
    }

    private Namespace getElementNameNamespace() {
        if (this.elementName == null && this.checkQName(this.owner.getElementQName())) {
            this.elementName = this.buildNamespace(this.owner.getElementQName());
        }
        return this.elementName;
    }

    private Namespace getElementTypeNamespace() {
        QName type;
        if (this.elementType == null && (type = this.owner.getSchemaType()) != null && this.checkQName(type)) {
            this.elementType = this.buildNamespace(type);
        }
        return this.elementType;
    }

    private Namespace buildNamespace(QName name) {
        String uri = StringSupport.trimOrNull((String)name.getNamespaceURI());
        if (uri == null) {
            throw new IllegalArgumentException("A non-empty namespace URI must be supplied");
        }
        String prefix = StringSupport.trimOrNull((String)name.getPrefix());
        return new Namespace(uri, prefix);
    }

    private void addNamespace(Set<Namespace> namespaces, Namespace newNamespace) {
        if (newNamespace == null) {
            return;
        }
        namespaces.add(newNamespace);
    }

    private void removeNamespace(Set<Namespace> namespaces, Namespace oldNamespace) {
        if (oldNamespace == null) {
            return;
        }
        namespaces.remove(oldNamespace);
    }

    private Set<Namespace> mergeNamespaceCollections(Collection<Namespace> ... namespaces) {
        LazySet newNamespaces = new LazySet();
        for (Collection<Namespace> nsCollection : namespaces) {
            for (Namespace ns : nsCollection) {
                if (ns == null) continue;
                this.addNamespace((Set<Namespace>)newNamespaces, ns);
            }
        }
        return newNamespaces;
    }

    private Set<Namespace> getVisibleNamespaces() {
        LazySet namespaces = new LazySet();
        if (this.getElementNameNamespace() != null) {
            namespaces.add((Object)this.getElementNameNamespace());
        }
        if (this.getElementTypeNamespace() != null) {
            namespaces.add((Object)XSI_NAMESPACE);
        }
        for (Namespace attribName : this.attrNames) {
            if (attribName == null) continue;
            namespaces.add((Object)attribName);
        }
        return namespaces;
    }

    private Set<Namespace> getNonVisibleNamespaceCandidates() {
        LazySet namespaces = new LazySet();
        if (this.getElementTypeNamespace() != null) {
            namespaces.add((Object)this.getElementTypeNamespace());
        }
        for (Namespace attribValue : this.attrValues.values()) {
            if (attribValue == null) continue;
            namespaces.add((Object)attribValue);
        }
        if (this.contentValue != null) {
            namespaces.add((Object)this.contentValue);
        }
        return namespaces;
    }

    private void addPrefixes(Set<String> prefixes, Collection<Namespace> namespaces) {
        for (Namespace ns : namespaces) {
            String prefix = StringSupport.trimOrNull((String)ns.getNamespacePrefix());
            if (prefix == null) {
                prefix = DEFAULT_NS_TOKEN;
            }
            prefixes.add(prefix);
        }
    }

    private boolean checkQName(QName name) {
        return !Strings.isNullOrEmpty((String)name.getNamespaceURI());
    }
}

