/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import edu.vt.middleware.crypt.x509.types.AbstractList;
import edu.vt.middleware.crypt.x509.types.AttributeTypeAndValue;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativeDistinguishedName
extends AbstractList<AttributeTypeAndValue> {
    public static final char SEPARATOR_CHAR = '+';

    public RelativeDistinguishedName(List<AttributeTypeAndValue> listOfValues) {
        if (listOfValues == null) {
            throw new IllegalArgumentException("List of values cannot be null.");
        }
        if (listOfValues.size() == 0) {
            throw new IllegalArgumentException("List must contain at least one value.");
        }
        this.items = listOfValues.toArray(new AttributeTypeAndValue[listOfValues.size()]);
    }

    public RelativeDistinguishedName(AttributeTypeAndValue[] arrayOfValues) {
        if (arrayOfValues == null) {
            throw new IllegalArgumentException("Array of values cannot be null.");
        }
        if (arrayOfValues.length == 0) {
            throw new IllegalArgumentException("Array must contain at least one value.");
        }
        this.items = arrayOfValues;
    }

    public RelativeDistinguishedName(AttributeTypeAndValue value) {
        this(new AttributeTypeAndValue[]{value});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        int i = 0;
        for (AttributeTypeAndValue item : (AttributeTypeAndValue[])this.items) {
            if (i++ > 0) {
                sb.append('+');
            }
            sb.append(item.toString());
        }
        return sb.toString();
    }

    public static RelativeDistinguishedName fromASN1Set(ASN1Set set) {
        ArrayList<AttributeTypeAndValue> values = new ArrayList<AttributeTypeAndValue>();
        for (int i = 0; i < set.size(); ++i) {
            DEREncodable value = set.getObjectAt(i);
            if (!(value instanceof ASN1Sequence)) {
                throw new IllegalArgumentException("Value must be ASN.1 sequence.");
            }
            ASN1Sequence seq = (ASN1Sequence)value;
            if (seq.size() != 2) {
                throw new IllegalArgumentException("Illegal sequence size " + seq.size());
            }
            if (!(seq.getObjectAt(0) instanceof DERObjectIdentifier)) {
                throw new IllegalArgumentException("First sequence item must be OID.");
            }
            values.add(new AttributeTypeAndValue(seq.getObjectAt(0).toString(), seq.getObjectAt(1).toString()));
        }
        return new RelativeDistinguishedName(values);
    }
}

