/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.x509.types;

import edu.vt.middleware.crypt.util.HexConverter;
import java.util.Arrays;

public class KeyIdentifier {
    private static final int HASH_FACTOR = 31;
    private final HexConverter converter = new HexConverter(true);
    private byte[] identifier;

    public KeyIdentifier(byte[] id) {
        this.identifier = id;
    }

    public KeyIdentifier(String fingerprint) {
        this.identifier = this.converter.toBytes(fingerprint);
    }

    public byte[] getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        return this.converter.fromBytes(this.identifier);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == this) {
            result = true;
        } else if (obj == null || obj.getClass() != this.getClass()) {
            result = false;
        } else {
            KeyIdentifier other = (KeyIdentifier)obj;
            result = Arrays.equals(this.identifier, other.getIdentifier());
        }
        return result;
    }

    public int hashCode() {
        return 31 * this.getClass().hashCode() + Arrays.hashCode(this.identifier);
    }
}

